/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link.controller;

import com.simibubi.create.content.redstone.link.controller.LecternControllerBlockEntity;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerItem;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerPacketBase;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerServerHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class LinkedControllerInputPacket
extends LinkedControllerPacketBase {
    private Collection<Integer> activatedButtons;
    private boolean press;

    public LinkedControllerInputPacket(Collection<Integer> activatedButtons, boolean press) {
        this(activatedButtons, press, null);
    }

    public LinkedControllerInputPacket(Collection<Integer> activatedButtons, boolean press, BlockPos lecternPos) {
        super(lecternPos);
        this.activatedButtons = activatedButtons;
        this.press = press;
    }

    public LinkedControllerInputPacket(FriendlyByteBuf buffer) {
        super(buffer);
        this.activatedButtons = new ArrayList<Integer>();
        this.press = buffer.readBoolean();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.activatedButtons.add(buffer.m_130242_());
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.press);
        buffer.m_130130_(this.activatedButtons.size());
        this.activatedButtons.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
    }

    @Override
    protected void handleLectern(ServerPlayer player, LecternControllerBlockEntity lectern) {
        if (lectern.isUsedBy((Player)player)) {
            this.handleItem(player, lectern.getController());
        }
    }

    @Override
    protected void handleItem(ServerPlayer player, ItemStack heldItem) {
        Level world = player.m_20193_();
        UUID uniqueID = player.m_142081_();
        BlockPos pos = player.m_142538_();
        if (player.m_5833_() && this.press) {
            return;
        }
        LinkedControllerServerHandler.receivePressed((LevelAccessor)world, pos, uniqueID, this.activatedButtons.stream().map(i -> LinkedControllerItem.toFrequency(heldItem, i)).collect(Collectors.toList()), this.press);
    }
}

