/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.json.AddToolDataFunction;
import slimeknights.tconstruct.library.json.RandomMaterial;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    private static boolean matches(boolean hasNoTypes, @Nullable ResourceKey<Biome> key, Biome.BiomeCategory given, @Nullable Biome.BiomeCategory check, BiomeDictionary.Type type) {
        if (hasNoTypes || key == null) {
            if (check == null) {
                return given != Biome.BiomeCategory.NONE;
            }
            return given == check;
        }
        return BiomeDictionary.hasType(key, (BiomeDictionary.Type)type);
    }

    @SubscribeEvent
    static void onBiomeLoad(BiomeLoadingEvent event) {
        boolean hasNoTypes;
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        MobSpawnSettingsBuilder spawns = event.getSpawns();
        Biome.BiomeCategory category = event.getCategory();
        ResourceLocation name = event.getName();
        ResourceKey key = name == null ? null : ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
        boolean bl = hasNoTypes = key == null || !BiomeDictionary.hasAnyType((ResourceKey)key);
        if (WorldEvents.matches(hasNoTypes, (ResourceKey<Biome>)key, category, Biome.BiomeCategory.NETHER, BiomeDictionary.Type.NETHER)) {
            if (((Boolean)Config.COMMON.generateCobalt.get()).booleanValue()) {
                TinkerWorld.placedSmallCobaltOre.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, holder));
                TinkerWorld.placedLargeCobaltOre.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, holder));
            }
            if (((Boolean)Config.COMMON.ichorGeodes.get()).booleanValue()) {
                TinkerWorld.placedIchorGeode.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, holder));
            }
        } else if (WorldEvents.matches(hasNoTypes, (ResourceKey<Biome>)key, category, Biome.BiomeCategory.THEEND, BiomeDictionary.Type.END)) {
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TinkerWorld.enderSlimeEntity.get(), 10, 2, 4));
            if (((Boolean)Config.COMMON.enderGeodes.get()).booleanValue() && key != null && !Biomes.f_48210_.equals((Object)key)) {
                TinkerWorld.placedEnderGeode.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, holder));
            }
        } else if (WorldEvents.matches(hasNoTypes, (ResourceKey<Biome>)key, category, null, BiomeDictionary.Type.OVERWORLD)) {
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TinkerWorld.earthSlimeEntity.get(), 100, 2, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TinkerWorld.skySlimeEntity.get(), 100, 2, 4));
            if (((Boolean)Config.COMMON.earthGeodes.get()).booleanValue()) {
                TinkerWorld.placedEarthGeode.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, holder));
            }
            if (((Boolean)Config.COMMON.skyGeodes.get()).booleanValue()) {
                boolean add;
                if (hasNoTypes) {
                    add = category != Biome.BiomeCategory.OCEAN && category != Biome.BiomeCategory.BEACH && category != Biome.BiomeCategory.RIVER;
                } else {
                    boolean bl2 = add = !BiomeDictionary.hasType((ResourceKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && !BiomeDictionary.hasType((ResourceKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
                }
                if (add) {
                    TinkerWorld.placedSkyGeode.getHolder().ifPresent(holder -> generation.m_204201_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, holder));
                }
            }
        }
    }

    private static void injectInto(LootTableLoadEvent event, String poolName, LootPoolEntryContainer ... entries) {
        LootPool pool = event.getTable().getPool(poolName);
        if (pool != null) {
            int oldLength = pool.f_79023_.length;
            pool.f_79023_ = Arrays.copyOf(pool.f_79023_, oldLength + entries.length);
            System.arraycopy(entries, 0, pool.f_79023_, oldLength, entries.length);
        }
    }

    private static LootPoolEntryContainer makeSeed(SlimeType type, int weight) {
        return LootItem.m_79579_((ItemLike)((ItemLike)TinkerWorld.slimeGrassSeeds.get((Enum)type))).m_79707_(weight).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))).m_7512_();
    }

    private static LootPoolEntryContainer makeSapling(SlimeType type, int weight) {
        return LootItem.m_79579_((ItemLike)((ItemLike)TinkerWorld.slimeSapling.get((Enum)type))).m_79707_(weight).m_7512_();
    }

    @SubscribeEvent
    static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if ("minecraft".equals(name.m_135827_())) {
            switch (name.m_135815_()) {
                case "chests/simple_dungeon": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "pool1", WorldEvents.makeSeed(SlimeType.EARTH, 3), WorldEvents.makeSeed(SlimeType.SKY, 7));
                    WorldEvents.injectInto(event, "main", WorldEvents.makeSapling(SlimeType.EARTH, 3), WorldEvents.makeSapling(SlimeType.SKY, 7));
                    break;
                }
                case "chests/nether_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "main", WorldEvents.makeSeed(SlimeType.BLOOD, 5));
                    break;
                }
                case "chests/bastion_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "pool2", WorldEvents.makeSapling(SlimeType.BLOOD, 1));
                    break;
                }
                case "chests/end_city_treasure": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "main", WorldEvents.makeSeed(SlimeType.ENDER, 5), WorldEvents.makeSapling(SlimeType.ENDER, 3));
                    break;
                }
                case "gameplay/piglin_bartering": {
                    int weight = (Integer)Config.COMMON.barterBlazingBlood.get();
                    if (weight <= 0) break;
                    WorldEvents.injectInto(event, "main", LootItem.m_79579_(TinkerSmeltery.scorchedLantern).m_79707_(weight).m_5577_((LootItemFunction.Builder)SetFluidLootFunction.builder((FluidStack)new FluidStack((Fluid)TinkerFluids.blazingBlood.get(), 50))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_7512_());
                    break;
                }
                case "chests/spawn_bonus_chest": {
                    int weight = (Integer)Config.COMMON.tinkerToolBonusChest.get();
                    if (weight <= 0) break;
                    RandomMaterial randomHead = RandomMaterial.random(HeadMaterialStats.ID).tier(1).build();
                    RandomMaterial firstHandle = RandomMaterial.firstWithStat(HandleMaterialStats.ID);
                    RandomMaterial randomBinding = RandomMaterial.random(ExtraMaterialStats.ID).tier(1).build();
                    WorldEvents.injectInto(event, "main", LootItem.m_79579_((ItemLike)((ItemLike)TinkerTools.handAxe.get())).m_79707_(weight).m_5577_((LootItemFunction.Builder)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).m_7512_());
                    WorldEvents.injectInto(event, "pool1", LootItem.m_79579_((ItemLike)((ItemLike)TinkerTools.pickaxe.get())).m_79707_(weight).m_5577_((LootItemFunction.Builder)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).m_7512_());
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    static void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        Item item = helmet.m_41720_();
        if (item != Items.f_41852_ && TinkerWorld.headItems.contains((IForgeRegistryEntry)item) && lookingEntity.m_6095_() == ((TinkerHeadType)((SkullBlock)((BlockItem)item).m_40614_()).m_48754_()).getType()) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent
    static void creeperKill(LivingDropsEvent event) {
        LivingEntity dying;
        TinkerHeadType headType;
        Creeper creeper;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7639_()) instanceof Creeper && (creeper = (Creeper)entity).m_32313_() && (headType = TinkerHeadType.fromEntityType((dying = event.getEntityLiving()).m_6095_())) != null && ((Boolean)Config.COMMON.headDrops.get((Object)headType).get()).booleanValue()) {
            creeper.m_32314_();
            event.getDrops().add(dying.m_19998_((ItemLike)TinkerWorld.heads.get((Enum)headType)));
        }
    }
}

