/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class SlurpingModifier
extends TankModifier
implements KeybindInteractModifierHook,
GeneralInteractionModifierHook {
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final TinkerDataCapability.TinkerDataKey<SlurpingInfo> SLURP_FINISH_TIME = TConstruct.createKey("slurping_finish");

    public SlurpingModifier() {
        super(1000);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, this::playerTick);
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
        FluidStack fluid;
        if (!player.m_6144_() && !(fluid = this.getFluid(tool)).isEmpty() && SpillingFluidManager.INSTANCE.contains(fluid.getFluid())) {
            player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(SLURP_FINISH_TIME, new SlurpingInfo(fluid, player.f_19797_ + 20)));
            return true;
        }
        return false;
    }

    private static void addFluidParticles(Player player, FluidStack fluid, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 motion = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            motion = motion.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
            motion = motion.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
            Vec3 position = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.3, (double)(-RANDOM.nextFloat()) * 0.6 - 0.3, 0.6);
            position = position.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
            position = position.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
            position = position.m_82520_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            FluidParticleData data = new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid);
            if (player.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, 1, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_, 0.0);
                continue;
            }
            player.f_19853_.m_7106_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_);
        }
    }

    private void finishDrinking(IToolStackView tool, Player player, InteractionHand hand) {
        SpillingFluid recipe;
        FluidStack fluid;
        if (!player.f_19853_.f_46443_ && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            ToolAttackContext context = new ToolAttackContext((LivingEntity)player, player, hand, (Entity)player, (LivingEntity)player, false, 1.0f, false);
            FluidStack remaining = recipe.applyEffects(fluid, tool.getModifierLevel(this), context);
            if (!player.m_7500_()) {
                this.setFluid(tool, remaining);
            }
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_5833_()) {
            return;
        }
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            SlurpingInfo info = data.get(SLURP_FINISH_TIME);
            if (info != null) {
                int timeLeft = info.finishTime - player.f_19797_;
                if (timeLeft < 0) {
                    player.m_5496_(SoundEvents.f_11911_, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 16);
                    ToolStack tool = ToolStack.from(player.m_6844_(EquipmentSlot.HEAD));
                    this.finishDrinking(tool, player, InteractionHand.MAIN_HAND);
                    data.remove(SLURP_FINISH_TIME);
                } else if (timeLeft % 4 == 0) {
                    player.m_5496_(SoundEvents.f_11911_, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 5);
                }
            }
        });
    }

    @Override
    public void stopInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot) {
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.remove(SLURP_FINISH_TIME));
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        FluidStack fluid;
        if (source == InteractionSource.RIGHT_CLICK && !(fluid = this.getFluid(tool)).isEmpty() && SpillingFluidManager.INSTANCE.contains(fluid.getFluid())) {
            ModifierUtil.startUsingItem(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 21;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.DRINK;
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        if (timeLeft % 4 == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            FluidStack fluidStack = this.getFluid(tool);
            if (!fluidStack.isEmpty()) {
                SlurpingModifier.addFluidParticles(player, fluidStack, 5);
            }
        }
    }

    @Override
    public boolean onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.finishDrinking(tool, player, entity.m_7655_());
        }
        return true;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.ARMOR_INTERACT, TinkerHooks.CHARGEABLE_INTERACT);
    }

    private record SlurpingInfo(FluidStack fluid, int finishTime) {
    }
}

