/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.utils.TagUtil;

public class FuelModule
implements ContainerData {
    private static final BlockPos NULL_POS = new BlockPos(0, Short.MIN_VALUE, 0);
    public static final int SOLID_TEMPERATURE = 800;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> fluidListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset());
    private final NonNullConsumer<LazyOptional<IItemHandler>> itemListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset());
    private final MantleBlockEntity parent;
    private final Supplier<List<BlockPos>> tankSupplier;
    @Nullable
    private MeltingFuel lastRecipe;
    @Nullable
    private LazyOptional<IFluidHandler> fluidHandler;
    @Nullable
    private LazyOptional<IItemHandler> itemHandler;
    private BlockPos lastPos = NULL_POS;
    private List<LazyOptional<IFluidHandler>> tankDisplayHandlers;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> displayListener = new WeakConsumerWrapper((Object)this, (self, cap) -> {
        if (self.tankDisplayHandlers != null) {
            self.tankDisplayHandlers.remove(cap);
        }
    });
    private int fuel = 0;
    private int fuelQuality = 0;
    private int temperature = 0;
    private final NonNullFunction<IItemHandler, Integer> trySolidFuelConsume = handler -> this.trySolidFuel((IItemHandler)handler, true);
    private final NonNullFunction<IItemHandler, Integer> trySolidFuelNoConsume = handler -> this.trySolidFuel((IItemHandler)handler, false);
    private final NonNullFunction<IFluidHandler, Integer> tryLiquidFuelConsume = handler -> this.tryLiquidFuel((IFluidHandler)handler, true);
    private final NonNullFunction<IFluidHandler, Integer> tryLiquidFuelNoConsume = handler -> this.tryLiquidFuel((IFluidHandler)handler, false);
    private static final String TAG_FUEL = "fuel";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_LAST_FUEL = "last_fuel_tank";
    private static final int FUEL = 0;
    private static final int FUEL_QUALITY = 1;
    private static final int TEMPERATURE = 2;
    private static final int LAST_X = 3;
    private static final int LAST_Y = 4;
    private static final int LAST_Z = 5;

    private void reset() {
        this.fluidHandler = null;
        this.itemHandler = null;
        this.tankDisplayHandlers = null;
        this.lastPos = NULL_POS;
    }

    private Level getLevel() {
        return Objects.requireNonNull(this.parent.m_58904_(), "Parent tile entity has null world");
    }

    @Nullable
    private MeltingFuel findRecipe(Fluid fluid) {
        if (this.lastRecipe != null && this.lastRecipe.matches(fluid)) {
            return this.lastRecipe;
        }
        MeltingFuel recipe = MeltingFuelLookup.findFuel(fluid);
        if (recipe != null) {
            this.lastRecipe = recipe;
        }
        return recipe;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
        this.parent.setChangedFast();
    }

    private int trySolidFuel(IItemHandler handler, boolean consume) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            int time = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)((RecipeType)TinkerRecipeTypes.FUEL.get())) / 4;
            if (time <= 0) continue;
            if (consume) {
                ItemStack extracted = handler.extractItem(i, 1, false);
                if (extracted.m_41656_(stack)) {
                    ItemStack notInserted;
                    this.fuel += time;
                    this.fuelQuality = time;
                    this.temperature = 800;
                    this.parent.setChangedFast();
                    ItemStack container = extracted.getContainerItem();
                    if (!container.m_41619_() && !(notInserted = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)container, (boolean)false)).m_41619_()) {
                        Level world = this.getLevel();
                        double x = (double)(world.f_46441_.nextFloat() * 0.5f) + 0.25;
                        double y = (double)(world.f_46441_.nextFloat() * 0.5f) + 0.25;
                        double z = (double)(world.f_46441_.nextFloat() * 0.5f) + 0.25;
                        BlockPos pos = this.lastPos == NULL_POS ? this.parent.m_58899_() : this.lastPos;
                        ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, container);
                        itementity.m_32060_();
                        world.m_7967_((Entity)itementity);
                    }
                } else {
                    TConstruct.LOG.error("Invalid item removed from solid fuel handler");
                }
            }
            return 800;
        }
        return 0;
    }

    private NonNullFunction<IItemHandler, Integer> trySolidFuel(boolean consume) {
        return consume ? this.trySolidFuelConsume : this.trySolidFuelNoConsume;
    }

    private int tryLiquidFuel(IFluidHandler handler, boolean consume) {
        FluidStack fluid = handler.getFluidInTank(0);
        MeltingFuel recipe = this.findRecipe(fluid.getFluid());
        if (recipe != null) {
            int amount = recipe.getAmount(fluid.getFluid());
            if (fluid.getAmount() >= amount) {
                if (consume) {
                    FluidStack drained = handler.drain(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
                    if (drained.getAmount() != amount) {
                        TConstruct.LOG.error("Invalid amount of fuel drained from tank");
                    }
                    this.fuel += recipe.getDuration();
                    this.fuelQuality = recipe.getDuration();
                    this.temperature = recipe.getTemperature();
                    this.parent.setChangedFast();
                    return this.temperature;
                }
                return recipe.getTemperature();
            }
        }
        return 0;
    }

    private NonNullFunction<IFluidHandler, Integer> tryLiquidFuel(boolean consume) {
        return consume ? this.tryLiquidFuelConsume : this.tryLiquidFuelNoConsume;
    }

    private int tryFindFuel(BlockPos pos, boolean consume) {
        BlockEntity te = this.getLevel().m_7702_(pos);
        if (te != null) {
            LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            Optional temperature = capability.map(this.tryLiquidFuel(consume));
            if (temperature.isPresent()) {
                this.itemHandler = null;
                this.fluidHandler = capability;
                this.tankDisplayHandlers = null;
                capability.addListener(this.fluidListener);
                this.lastPos = pos;
                return (Integer)temperature.get();
            }
            LazyOptional itemCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            temperature = itemCap.map(this.trySolidFuel(consume));
            if (temperature.isPresent()) {
                this.fluidHandler = null;
                this.tankDisplayHandlers = null;
                this.itemHandler = itemCap;
                itemCap.addListener(this.itemListener);
                this.lastPos = pos;
                return (Integer)temperature.get();
            }
        }
        return 0;
    }

    public int findFuel(boolean consume) {
        int posTemp;
        Optional handlerTemp = Optional.empty();
        if (this.fluidHandler != null) {
            handlerTemp = this.fluidHandler.map(this.tryLiquidFuel(consume));
        } else if (this.itemHandler != null) {
            handlerTemp = this.itemHandler.map(this.trySolidFuel(consume));
        } else if (this.lastPos != NULL_POS && (posTemp = this.tryFindFuel(this.lastPos, consume)) > 0) {
            return posTemp;
        }
        if (handlerTemp.orElse(0) > 0) {
            return (Integer)handlerTemp.get();
        }
        for (BlockPos pos : this.tankSupplier.get()) {
            int posTemp2;
            if (pos.equals((Object)this.lastPos) || (posTemp2 = this.tryFindFuel(pos, consume)) <= 0) continue;
            return posTemp2;
        }
        if (consume) {
            this.temperature = 0;
        }
        return 0;
    }

    public void readFromTag(CompoundTag nbt) {
        if (nbt.m_128425_(TAG_FUEL, 99)) {
            this.fuel = nbt.m_128451_(TAG_FUEL);
        }
        if (nbt.m_128425_(TAG_TEMPERATURE, 99)) {
            this.temperature = nbt.m_128451_(TAG_TEMPERATURE);
        }
        if (nbt.m_128425_(TAG_LAST_FUEL, 99)) {
            this.lastPos = TagUtil.readPos(nbt, TAG_LAST_FUEL);
        }
    }

    public CompoundTag writeToTag(CompoundTag nbt) {
        nbt.m_128405_(TAG_FUEL, this.fuel);
        nbt.m_128405_(TAG_TEMPERATURE, this.temperature);
        if (this.lastPos != NULL_POS) {
            nbt.m_128365_(TAG_LAST_FUEL, (Tag)TagUtil.writePos(this.lastPos));
        }
        return nbt;
    }

    public int m_6499_() {
        return 6;
    }

    public int m_6413_(int index) {
        return switch (index) {
            case 0 -> this.fuel;
            case 1 -> this.fuelQuality;
            case 2 -> this.temperature;
            case 3 -> this.lastPos.m_123341_();
            case 4 -> this.lastPos.m_123342_();
            case 5 -> this.lastPos.m_123343_();
            default -> 0;
        };
    }

    public void m_8050_(int index, int value) {
        switch (index) {
            case 0: {
                this.fuel = value;
                break;
            }
            case 1: {
                this.fuelQuality = value;
                break;
            }
            case 2: {
                this.temperature = value;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                switch (index) {
                    case 3: {
                        this.lastPos = new BlockPos(value, this.lastPos.m_123342_(), this.lastPos.m_123343_());
                        break;
                    }
                    case 4: {
                        this.lastPos = new BlockPos(this.lastPos.m_123341_(), value, this.lastPos.m_123343_());
                        break;
                    }
                    case 5: {
                        this.lastPos = new BlockPos(this.lastPos.m_123341_(), this.lastPos.m_123342_(), value);
                    }
                }
                this.fluidHandler = null;
                this.itemHandler = null;
                this.tankDisplayHandlers = null;
            }
        }
    }

    public void clearCachedDisplayListeners() {
        this.tankDisplayHandlers = null;
    }

    public FuelInfo getFuelInfo() {
        BlockEntity te;
        List<BlockPos> positions = null;
        BlockPos mainTank = this.lastPos;
        if (mainTank.m_123342_() == NULL_POS.m_123342_()) {
            positions = this.tankSupplier.get();
            if (positions.isEmpty()) {
                return FuelInfo.EMPTY;
            }
            mainTank = positions.get(0);
            assert (mainTank != null);
        }
        if (this.fluidHandler == null && this.itemHandler == null && (te = this.getLevel().m_7702_(mainTank)) != null) {
            LazyOptional fluidCap = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (fluidCap.isPresent()) {
                this.fluidHandler = fluidCap;
                this.fluidHandler.addListener(this.fluidListener);
            } else {
                LazyOptional itemCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                if (itemCap.isPresent()) {
                    this.itemHandler = itemCap;
                    this.itemHandler.addListener(this.itemListener);
                }
            }
        }
        if (this.fluidHandler == null) {
            this.fluidHandler = LazyOptional.empty();
        }
        if (this.itemHandler == null) {
            this.itemHandler = LazyOptional.empty();
        }
        if (this.itemHandler.isPresent()) {
            return FuelInfo.ITEM;
        }
        FuelInfo info = this.fluidHandler.map(handler -> {
            MeltingFuel fuel;
            FluidStack fluid = handler.getFluidInTank(0);
            int temperature = 0;
            if (!fluid.isEmpty() && (fuel = this.findRecipe(fluid.getFluid())) != null) {
                temperature = fuel.getTemperature();
            }
            return FuelInfo.of(fluid, handler.getTankCapacity(0), temperature);
        }).orElse(FuelInfo.EMPTY);
        if (!info.isEmpty()) {
            Level world = this.getLevel();
            if (this.tankDisplayHandlers == null) {
                this.tankDisplayHandlers = new ArrayList<LazyOptional<IFluidHandler>>();
                if (positions == null) {
                    positions = this.tankSupplier.get();
                }
                for (BlockPos pos : positions) {
                    LazyOptional handler2;
                    BlockEntity te2;
                    if (pos.equals((Object)mainTank) || (te2 = world.m_7702_(pos)) == null || !(handler2 = te2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) continue;
                    handler2.addListener(this.displayListener);
                    this.tankDisplayHandlers.add((LazyOptional<IFluidHandler>)handler2);
                }
            }
            FluidStack currentFuel = info.getFluid();
            for (LazyOptional<IFluidHandler> capability : this.tankDisplayHandlers) {
                capability.ifPresent(handler -> {
                    FluidStack fluid = handler.getFluidInTank(0);
                    if (fluid.isEmpty()) {
                        info.add(0, handler.getTankCapacity(0));
                    } else if (currentFuel.isFluidEqual(fluid)) {
                        info.add(fluid.getAmount(), handler.getTankCapacity(0));
                    }
                });
            }
        }
        return info;
    }

    public FuelModule(MantleBlockEntity parent, Supplier<List<BlockPos>> tankSupplier) {
        this.parent = parent;
        this.tankSupplier = tankSupplier;
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getFuelQuality() {
        return this.fuelQuality;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class FuelInfo {
        public static final FuelInfo EMPTY = new FuelInfo(FluidStack.EMPTY, 0, 0, 0);
        public static final FuelInfo ITEM = new FuelInfo(FluidStack.EMPTY, 0, 0, 800);
        private final FluidStack fluid;
        private int totalAmount;
        private int capacity;
        private final int temperature;

        public static FuelInfo of(FluidStack fluid, int capacity, int temperature) {
            if (fluid.isEmpty()) {
                return EMPTY;
            }
            return new FuelInfo(fluid, fluid.getAmount(), Math.max(capacity, fluid.getAmount()), temperature);
        }

        protected void add(int amount, int capacity) {
            this.totalAmount += amount;
            this.capacity += capacity;
        }

        public boolean isItem() {
            return this == ITEM;
        }

        public boolean isEmpty() {
            return this.fluid.isEmpty() || this.totalAmount == 0 || this.capacity == 0;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getTemperature() {
            return this.temperature;
        }

        private FuelInfo(FluidStack fluid, int totalAmount, int capacity, int temperature) {
            this.fluid = fluid;
            this.totalAmount = totalAmount;
            this.capacity = capacity;
            this.temperature = temperature;
        }
    }
}

