/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public abstract class PartRequirement {
    public static final Serializer SERIALIZER = new Serializer();
    private final int weight;

    public static PartRequirement ofPart(IToolPart part, int weight) {
        return new ToolPart(part, weight);
    }

    public static PartRequirement ofStat(MaterialStatsId statsId, int weight) {
        return new StatType(statsId, weight);
    }

    @Nullable
    public abstract IToolPart getPart();

    public abstract boolean matches(Item var1);

    public abstract boolean canUseMaterial(MaterialVariantId var1);

    public abstract Component nameForMaterial(MaterialVariantId var1);

    public abstract MaterialStatsId getStatType();

    public abstract void write(FriendlyByteBuf var1);

    public abstract JsonObject serialize();

    public static PartRequirement read(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            IToolPart part = (IToolPart)RecipeHelper.readItem((FriendlyByteBuf)buffer, IToolPart.class);
            int weight = buffer.m_130242_();
            return PartRequirement.ofPart(part, weight);
        }
        MaterialStatsId statsId = new MaterialStatsId(buffer.m_130281_());
        int weight = buffer.m_130242_();
        return PartRequirement.ofStat(statsId, weight);
    }

    public PartRequirement(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartRequirement)) {
            return false;
        }
        PartRequirement other = (PartRequirement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getWeight() == other.getWeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartRequirement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeight();
        return result;
    }

    public String toString() {
        return "PartRequirement(weight=" + this.getWeight() + ")";
    }

    private static class ToolPart
    extends PartRequirement {
        private final IToolPart part;

        public ToolPart(IToolPart part, int weight) {
            super(weight);
            this.part = part;
        }

        @Override
        public boolean matches(Item item) {
            return this.part.m_5456_() == item;
        }

        @Override
        public boolean canUseMaterial(MaterialVariantId material) {
            return this.part.canUseMaterial(material.getId());
        }

        @Override
        public Component nameForMaterial(MaterialVariantId material) {
            return this.part.withMaterial(material).m_41786_();
        }

        @Override
        public MaterialStatsId getStatType() {
            return this.part.getStatType();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeBoolean(true);
            RecipeHelper.writeItem((FriendlyByteBuf)buffer, (ItemLike)this.part);
            buffer.m_130130_(this.getWeight());
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(this.part.m_5456_().getRegistryName()).toString());
            if (this.getWeight() != 1) {
                jsonObject.addProperty("weight", (Number)this.getWeight());
            }
            return jsonObject;
        }

        @Override
        public IToolPart getPart() {
            return this.part;
        }
    }

    private static class StatType
    extends PartRequirement {
        private final MaterialStatsId statType;

        public StatType(MaterialStatsId statType, int weight) {
            super(weight);
            this.statType = statType;
        }

        @Override
        @Nullable
        public IToolPart getPart() {
            return null;
        }

        @Override
        public boolean matches(Item item) {
            return false;
        }

        @Override
        public boolean canUseMaterial(MaterialVariantId material) {
            return MaterialRegistry.getInstance().getMaterialStats(material.getId(), this.statType).isPresent();
        }

        @Override
        public Component nameForMaterial(MaterialVariantId material) {
            return MaterialTooltipCache.getDisplayName(material);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeBoolean(false);
            buffer.m_130085_((ResourceLocation)this.statType);
            buffer.m_130130_(this.getWeight());
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("stat", this.statType.toString());
            if (this.getWeight() != 1) {
                jsonObject.addProperty("weight", (Number)this.getWeight());
            }
            return jsonObject;
        }

        @Override
        public MaterialStatsId getStatType() {
            return this.statType;
        }
    }

    protected static class Serializer
    implements JsonDeserializer<PartRequirement>,
    JsonSerializer<PartRequirement> {
        protected Serializer() {
        }

        public PartRequirement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"part");
            int weight = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"weight", (int)1);
            if (jsonObject.has("item")) {
                ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"item");
                if (!ForgeRegistries.ITEMS.containsKey(name)) {
                    throw new JsonSyntaxException("Invalid item '" + name + "' for tool part, does not exist");
                }
                Item item = Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(name));
                if (!(item instanceof IToolPart)) {
                    throw new JsonSyntaxException("Invalid item '" + name + "' for tool part, must implement IToolPart");
                }
                return PartRequirement.ofPart((IToolPart)item, weight);
            }
            if (jsonObject.has("stat")) {
                MaterialStatsId stat = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"stat"));
                return PartRequirement.ofStat(stat, weight);
            }
            throw new JsonSyntaxException("Invalid part, must have either 'item' or 'stat'");
        }

        public JsonElement serialize(PartRequirement part, Type typeOfSrc, JsonSerializationContext context) {
            return part.serialize();
        }
    }
}

