/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.BlockTransformModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ElytraFlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ShearsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorLootModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorWalkModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IElytraFlightModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class TinkerHooks {
    public static final ModifierHook<ConditionalStatModifierHook> CONDITIONAL_STAT = TinkerHooks.register("conditional_stat", ConditionalStatModifierHook.class, ConditionalStatModifierHook.ALL_MERGER, ConditionalStatModifierHook.EMPTY);
    public static final ModifierHook<LootingModifierHook> TOOL_LOOTING = TinkerHooks.register("tool_looting", LootingModifierHook.class, LootingModifierHook.SUM_MERGER, (tool, modifier, holder, target, damageSource, looting) -> modifier.getModifier().getLootingValue(tool, modifier.getLevel(), holder, target, damageSource, looting));
    public static final ModifierHook<LootingModifierHook> LEGGINGS_LOOTING = TinkerHooks.register("leggings_looting", LootingModifierHook.class, LootingModifierHook.SUM_MERGER, (tool, modifier, holder, target, damageSource, looting) -> {
        IArmorLootModifier armorLoot = modifier.getModifier().getModule(IArmorLootModifier.class);
        if (armorLoot != null) {
            return armorLoot.getLootingValue(tool, modifier.getLevel(), holder, target, damageSource, looting);
        }
        return looting;
    });
    public static final ModifierHook<LootingModifierHook> PROJECTILE_LOOTING = TinkerHooks.register("projectile_looting", LootingModifierHook.class, LootingModifierHook.SUM_MERGER, LootingModifierHook.DEFAULT);
    public static final ModifierHook<HarvestEnchantmentsModifierHook> TOOL_HARVEST_ENCHANTMENTS = TinkerHooks.register("tool_harvest_enchantments", HarvestEnchantmentsModifierHook.class, HarvestEnchantmentsModifierHook.ALL_MERGER, (tool, modifier, context, consumer) -> modifier.getModifier().applyHarvestEnchantments(tool, modifier.getLevel(), context, consumer));
    public static final ModifierHook<HarvestEnchantmentsModifierHook> LEGGINGS_HARVEST_ENCHANTMENTS = TinkerHooks.register("leggings_harvest_enchantments", HarvestEnchantmentsModifierHook.class, HarvestEnchantmentsModifierHook.ALL_MERGER, (tool, modifier, context, consumer) -> {
        IArmorLootModifier armorLoot = modifier.getModifier().getModule(IArmorLootModifier.class);
        if (armorLoot != null) {
            armorLoot.applyHarvestEnchantments(tool, modifier.getLevel(), context, consumer);
        }
    });
    public static final ModifierHook<ProjectileLaunchModifierHook> PROJECTILE_LAUNCH = TinkerHooks.register("projectile_launch", ProjectileLaunchModifierHook.class, ProjectileLaunchModifierHook.ALL_MERGER, ProjectileLaunchModifierHook.EMPTY);
    public static final ModifierHook<ProjectileHitModifierHook> PROJECTILE_HIT = TinkerHooks.register("projectile_hit", ProjectileHitModifierHook.class, ProjectileHitModifierHook.FIRST_MERGER, ProjectileHitModifierHook.EMPTY);
    public static final ModifierHook<BowAmmoModifierHook> BOW_AMMO = TinkerHooks.register("bow_ammo", BowAmmoModifierHook.class, BowAmmoModifierHook.EMPTY);
    public static final ModifierHook<ElytraFlightModifierHook> ELYTRA_FLIGHT = TinkerHooks.register("elytra_flight", ElytraFlightModifierHook.class, ElytraFlightModifierHook.FIRST_MERGER, (tool, modifier, entity, flightTicks) -> {
        IElytraFlightModifier elytraFlight = modifier.getModifier().getModule(IElytraFlightModifier.class);
        return elytraFlight != null && !elytraFlight.elytraFlightTick(tool, modifier.getLevel(), entity, flightTicks);
    });
    public static final ModifierHook<ArmorWalkModifierHook> BOOT_WALK = TinkerHooks.register("boot_walk", ArmorWalkModifierHook.class, ArmorWalkModifierHook.ALL_MERGER, (tool, modifier, living, prevPos, newPos) -> {
        IArmorWalkModifier armorWalk = modifier.getModifier().getModule(IArmorWalkModifier.class);
        if (armorWalk != null) {
            armorWalk.onWalk(tool, modifier.getLevel(), living, prevPos, newPos);
        }
    });
    @Deprecated
    public static final ModifierHook<GeneralInteractionModifierHook> GENERAL_INTERACT = TinkerHooks.register("general_interact", GeneralInteractionModifierHook.class, GeneralInteractionModifierHook.FIRST_MERGER, GeneralInteractionModifierHook.FALLBACK);
    public static final ModifierHook<GeneralInteractionModifierHook> CHARGEABLE_INTERACT = TinkerHooks.register("chargable_interact", GeneralInteractionModifierHook.class, GeneralInteractionModifierHook.FIRST_MERGER, (tool, modifier, player, hand, source) -> modifier.getHook(GENERAL_INTERACT).onToolUse(tool, modifier, player, hand, source));
    public static final ModifierHook<BlockInteractionModifierHook> BLOCK_INTERACT = TinkerHooks.register("block_interact", BlockInteractionModifierHook.class, BlockInteractionModifierHook.FIRST_MERGER, BlockInteractionModifierHook.FALLBACK);
    public static final ModifierHook<EntityInteractionModifierHook> ENTITY_INTERACT = TinkerHooks.register("entity_interact", EntityInteractionModifierHook.class, EntityInteractionModifierHook.FIRST_MERGER, EntityInteractionModifierHook.FALLBACK);
    public static final ModifierHook<KeybindInteractModifierHook> ARMOR_INTERACT = TinkerHooks.register("armor_interact", KeybindInteractModifierHook.class, KeybindInteractModifierHook.MERGER, new KeybindInteractModifierHook(){

        @Override
        public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
            IArmorInteractModifier interact = modifier.getModifier().getModule(IArmorInteractModifier.class);
            if (interact != null) {
                return interact.startArmorInteract(tool, modifier.getLevel(), player, slot, keyModifier);
            }
            return false;
        }

        @Override
        public void stopInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot) {
            IArmorInteractModifier interact = modifier.getModifier().getModule(IArmorInteractModifier.class);
            if (interact != null) {
                interact.stopArmorInteract(tool, modifier.getLevel(), player, slot);
            }
        }
    });
    public static final ModifierHook<PlantHarvestModifierHook> PLANT_HARVEST = TinkerHooks.register("plant_harvest", PlantHarvestModifierHook.class, PlantHarvestModifierHook.ALL_MERGER, (tool, modifier, context, world, state, pos) -> {
        IHarvestModifier plantHarvest = modifier.getModifier().getModule(IHarvestModifier.class);
        if (plantHarvest != null) {
            plantHarvest.afterHarvest(tool, modifier.getLevel(), context, world, state, pos);
        }
    });
    public static final ModifierHook<ShearsModifierHook> SHEAR_ENTITY = TinkerHooks.register("shear_entity", ShearsModifierHook.class, ShearsModifierHook.ALL_MERGER, new ShearsModifierHook(){

        @Override
        public void afterShearEntity(IToolStackView tool, ModifierEntry modifier, Player player, Entity entity, boolean isTarget) {
            IShearModifier shearModifier = modifier.getModifier().getModule(IShearModifier.class);
            if (shearModifier != null) {
                shearModifier.afterShearEntity(tool, modifier.getLevel(), player, entity, isTarget);
            }
        }
    });
    public static final ModifierHook<BlockTransformModifierHook> BLOCK_TRANSFORM = TinkerHooks.register("block_transform", BlockTransformModifierHook.class, BlockTransformModifierHook.ALL_MERGER, BlockTransformModifierHook.EMPTY);

    private TinkerHooks() {
    }

    public static void init() {
    }

    private static <T> ModifierHook<T> register(String name, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        return ModifierHooks.register(TConstruct.getResource(name), filter, defaultInstance, merger);
    }

    private static <T> ModifierHook<T> register(String name, Class<T> filter, T defaultInstance) {
        return TinkerHooks.register(name, filter, null, defaultInstance);
    }
}

