/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ModifierHook<T> {
    private final ResourceLocation name;
    private final Class<T> filter;
    private final T defaultInstance;
    @Nullable
    private final Function<Collection<T>, T> merger;

    public ModifierHook(ResourceLocation name, Class<T> filter, T defaultInstance) {
        this(name, filter, defaultInstance, null);
    }

    public boolean isValid(Object module) {
        return this.filter.isInstance(module);
    }

    public T cast(Object module) {
        return (T)module;
    }

    public boolean canMerge() {
        return this.merger != null;
    }

    public T merge(Collection<T> modules) {
        if (modules.isEmpty()) {
            return this.defaultInstance;
        }
        if (modules.size() == 1) {
            return modules.iterator().next();
        }
        if (this.merger == null) {
            throw new IllegalStateException(this.name + " does not support merging");
        }
        return this.merger.apply(modules);
    }

    public String toString() {
        return "ModifierHook{" + this.name + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifierHook that = (ModifierHook)o;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public ModifierHook(ResourceLocation name, Class<T> filter, T defaultInstance, @Nullable Function<Collection<T>, T> merger) {
        this.name = name;
        this.filter = filter;
        this.defaultInstance = defaultInstance;
        this.merger = merger;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public T getDefaultInstance() {
        return this.defaultInstance;
    }
}

