/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.modifier;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.SlotType;

public class SlotTypeModifierPredicate
implements ModifierPredicate {
    @Nullable
    private final SlotType slotType;
    public static final GenericLoaderRegistry.IGenericLoader<SlotTypeModifierPredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<SlotTypeModifierPredicate>(){

        public SlotTypeModifierPredicate deserialize(JsonObject json) {
            SlotType slotType = null;
            if (json.has("slot")) {
                slotType = SlotType.getOrCreate(GsonHelper.m_13906_((JsonObject)json, (String)"slot"));
            }
            return new SlotTypeModifierPredicate(slotType);
        }

        public SlotTypeModifierPredicate fromNetwork(FriendlyByteBuf buffer) {
            SlotType slotType = null;
            if (buffer.readBoolean()) {
                slotType = SlotType.read(buffer);
            }
            return new SlotTypeModifierPredicate(slotType);
        }

        public void serialize(SlotTypeModifierPredicate object, JsonObject json) {
            if (object.slotType != null) {
                json.addProperty("slot", object.slotType.getName());
            }
        }

        public void toNetwork(SlotTypeModifierPredicate object, FriendlyByteBuf buffer) {
            if (object.slotType != null) {
                buffer.writeBoolean(true);
                object.slotType.write(buffer);
            } else {
                buffer.writeBoolean(false);
            }
        }
    };

    public boolean matches(ModifierId input) {
        return ModifierRecipeLookup.isRecipeModifier(this.slotType, input);
    }

    public GenericLoaderRegistry.IGenericLoader<SlotTypeModifierPredicate> getLoader() {
        return LOADER;
    }

    public SlotTypeModifierPredicate(@Nullable SlotType slotType) {
        this.slotType = slotType;
    }
}

