/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.sectiontransformer.materials;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.client.book.content.ContentMaterial;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.AbstractMaterialSectionTransformer;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class TierRangeMaterialSectionTransformer
extends BookTransformer {
    private static final Set<MaterialStatsId> MELEE_HARVEST = ImmutableSet.of((Object)((Object)HeadMaterialStats.ID), (Object)((Object)HandleMaterialStats.ID), (Object)((Object)ExtraMaterialStats.ID));
    private static final ResourceLocation KEY = TConstruct.getResource("material_tier");
    private static final Map<ResourceLocation, MaterialType> MATERIAL_TYPES = new HashMap<ResourceLocation, MaterialType>();
    public static final TierRangeMaterialSectionTransformer INSTANCE = new TierRangeMaterialSectionTransformer();

    public static void registerMaterialType(ResourceLocation id, BiFunction<MaterialVariantId, Boolean, AbstractMaterialContent> constructor, MaterialStatsId ... stats) {
        if (MATERIAL_TYPES.putIfAbsent(id, new MaterialType(constructor, (Set<MaterialStatsId>)ImmutableSet.copyOf((Object[])stats))) != null) {
            throw new IllegalArgumentException("Duplicate material stat group " + id);
        }
    }

    public void transform(BookData book) {
        for (SectionData section : book.sections) {
            JsonElement json = (JsonElement)section.extraData.get(KEY);
            if (json == null) continue;
            try {
                Set<MaterialStatsId> visibleStats;
                Function<MaterialVariantId, AbstractMaterialContent> pageBuilder;
                int min = 0;
                int max = Integer.MAX_VALUE;
                TagKey<IMaterial> tag = null;
                if (json.isJsonPrimitive()) {
                    if (json.getAsJsonPrimitive().isNumber()) {
                        max = min = json.getAsInt();
                    } else {
                        tag = MaterialManager.getTag(JsonHelper.convertToResourceLocation((JsonElement)json, (String)KEY.toString()));
                    }
                    pageBuilder = id -> new ContentMaterial((MaterialVariantId)id, false);
                    visibleStats = MELEE_HARVEST;
                    TConstruct.LOG.warn("Using tconstruct:material_tier with a number or tag is deprecated");
                } else if (json.isJsonObject()) {
                    ResourceLocation type;
                    MaterialType typeData;
                    JsonObject jsonObject = json.getAsJsonObject();
                    if (jsonObject.has("tier")) {
                        max = min = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"tier");
                    } else {
                        min = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"min", (int)0);
                        max = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"max", (int)Integer.MAX_VALUE);
                    }
                    if (jsonObject.has("tag")) {
                        tag = MaterialManager.getTag(JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"tag"));
                    }
                    if ((typeData = MATERIAL_TYPES.get(type = jsonObject.has("type") ? JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"type") : TConstruct.getResource("melee_harvest"))) == null) {
                        throw new JsonSyntaxException("Invalid material section type " + type);
                    }
                    visibleStats = typeData.visibleStats();
                    pageBuilder = typeData.getMapping(GsonHelper.m_13855_((JsonObject)jsonObject, (String)"detailed", (boolean)false));
                } else {
                    throw new JsonSyntaxException("Invalid tconstruct:material_tier, expected number or JSON object");
                }
                AbstractMaterialSectionTransformer.createPages(book, section, new ValidMaterial(visibleStats, min, max, tag), pageBuilder);
            }
            catch (JsonSyntaxException e) {
                TConstruct.LOG.error("Failed to parse material tier section data", (Throwable)e);
            }
        }
    }

    private record MaterialType(BiFunction<MaterialVariantId, Boolean, AbstractMaterialContent> pageConstructor, Set<MaterialStatsId> visibleStats) {
        public Function<MaterialVariantId, AbstractMaterialContent> getMapping(boolean detailed) {
            return id -> this.pageConstructor.apply((MaterialVariantId)id, detailed);
        }
    }

    public record ValidMaterial(Set<MaterialStatsId> visibleStats, int min, int max, @Nullable TagKey<IMaterial> tag) implements Predicate<IMaterial>
    {
        @Deprecated
        public ValidMaterial(Set<MaterialStatsId> visibleStats, int min, int max) {
            this(visibleStats, min, max, null);
        }

        @Override
        public boolean test(IMaterial material) {
            int tier = material.getTier();
            if (tier < this.min || tier > this.max) {
                return false;
            }
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            MaterialId id = material.getIdentifier();
            if (this.tag != null && !registry.isInTag(id, this.tag)) {
                return false;
            }
            for (IMaterialStats stats : registry.getAllStats(id)) {
                if (!this.visibleStats.contains((Object)stats.getIdentifier())) continue;
                return true;
            }
            return false;
        }
    }
}

