/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items.base;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.client.KeyBindings;
import de.srendi.advancedperipherals.common.items.base.IInventoryItem;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.common.util.TranslationUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseItem
extends Item {
    private Component description;

    public BaseItem(Item.Properties properties) {
        super(properties.m_41491_(AdvancedPeripherals.TAB));
    }

    public BaseItem() {
        super(new Item.Properties().m_41491_(AdvancedPeripherals.TAB));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
        }
        BaseItem baseItem = this;
        if (baseItem instanceof IInventoryItem) {
            IInventoryItem inventoryItem = (IInventoryItem)((Object)baseItem);
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerIn;
            ItemStack stack = playerIn.m_21120_(handIn);
            NetworkHooks.openGui((ServerPlayer)serverPlayerEntity, (MenuProvider)inventoryItem.createContainer(playerIn, stack), buf -> buf.m_130055_(stack));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!KeyBindings.DESCRIPTION_KEYBINDING.m_90857_()) {
            tooltip.add(EnumColor.buildTextComponent((Component)new TranslatableComponent("item.advancedperipherals.tooltip.show_desc", new Object[]{KeyBindings.DESCRIPTION_KEYBINDING.m_90863_()})));
        } else {
            tooltip.add(EnumColor.buildTextComponent(this.m_41466_()));
        }
        if (!this.isEnabled()) {
            tooltip.add(EnumColor.buildTextComponent((Component)new TranslatableComponent("item.advancedperipherals.tooltip.disabled")));
        }
    }

    @NotNull
    public Component m_41466_() {
        if (this.description == null) {
            this.description = TranslationUtil.itemTooltip(this.m_5524_());
        }
        return this.description;
    }

    public abstract boolean isEnabled();
}

