/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PoweredPeripheralBlockEntity<T extends BasePeripheral<?>>
extends PeripheralBlockEntity<T> {
    private final LazyOptional<IEnergyStorage> lazyEnergyStorage;

    public PoweredPeripheralBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.lazyEnergyStorage = (Boolean)APConfig.PERIPHERALS_CONFIG.enablePoweredPeripherals.get() != false ? LazyOptional.of(() -> new EnergyStorage(this.getMaxEnergyStored())) : LazyOptional.empty();
    }

    protected abstract int getMaxEnergyStored();

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.lazyEnergyStorage.ifPresent(iEnergyStorage -> compound.m_128405_("energy", iEnergyStorage.getEnergyStored()));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.lazyEnergyStorage.ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(compound.m_128451_("energy") - iEnergyStorage.getEnergyStored(), false));
    }

    @Override
    @NotNull
    public <T1> LazyOptional<T1> getCapability(@NotNull Capability<T1> cap, @Nullable Direction direction) {
        if (cap == CapabilityEnergy.ENERGY && this.lazyEnergyStorage.isPresent()) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }
}

