/*
 * Decompiled with CFR 0.152.
 */
package com.tabithastrong.compactstorage;

import com.mojang.logging.LogUtils;
import com.tabithastrong.compactstorage.block.CompactBarrelBlock;
import com.tabithastrong.compactstorage.block.CompactChestBlock;
import com.tabithastrong.compactstorage.block.entity.CompactBarrelBlockEntity;
import com.tabithastrong.compactstorage.block.entity.CompactChestBlockEntity;
import com.tabithastrong.compactstorage.item.BackpackItem;
import com.tabithastrong.compactstorage.item.StorageUpgradeItem;
import com.tabithastrong.compactstorage.screen.CompactChestScreenHandler;
import java.util.HashMap;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="compact_storage")
public class CompactStorage {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "compact_storage";
    public static final String MOD_NAME = "CompactStorage";
    public static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"compact_storage");
    public static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"compact_storage");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"compact_storage");
    public static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"compact_storage");
    public static ResourceLocation COMPACT_CHEST_GENERIC_IDENTIFIER = new ResourceLocation("compact_storage", "compact_chest");
    public static ResourceLocation COMPACT_BARREL_GENERIC_IDENTIFIER = new ResourceLocation("compact_storage", "compact_barrel");
    public static final RegistryObject<Block>[] COMPACT_CHEST_BLOCKS = new RegistryObject[16];
    public static final RegistryObject<Block>[] COMPACT_BARREL_BLOCKS = new RegistryObject[16];
    public static RegistryObject<BlockEntityType<CompactBarrelBlockEntity>> COMPACT_BARREL_ENTITY_TYPE = BLOCK_ENTITY_TYPE_REGISTER.register("compact_barrel", () -> BlockEntityType.Builder.m_155273_(CompactBarrelBlockEntity::new, (Block[])CompactStorage.mapRegistryObjectToBlocks(COMPACT_BARREL_BLOCKS)).m_58966_(null));
    public static RegistryObject<BlockEntityType<CompactChestBlockEntity>> COMPACT_CHEST_ENTITY_TYPE = BLOCK_ENTITY_TYPE_REGISTER.register("compact_chest", () -> BlockEntityType.Builder.m_155273_(CompactChestBlockEntity::new, (Block[])CompactStorage.mapRegistryObjectToBlocks(COMPACT_CHEST_BLOCKS)).m_58966_(null));
    public static final String COMPACT_CHEST_TRANSLATION_KEY = Util.m_137492_((String)"container", (ResourceLocation)COMPACT_CHEST_GENERIC_IDENTIFIER);
    public static final RegistryObject<MenuType<CompactChestScreenHandler>> COMPACT_CHEST_SCREEN_HANDLER = MENU_TYPE_REGISTER.register("compact_chest", () -> new MenuType((MenuType.MenuSupplier)new IContainerFactory<CompactChestScreenHandler>(){

        public CompactChestScreenHandler create(int windowId, Inventory inv, FriendlyByteBuf data) {
            return new CompactChestScreenHandler(windowId, inv, data);
        }
    }));
    public static final HashMap<DyeColor, RegistryObject<Block>> DYE_COLOR_TO_COMPACT_CHEST_MAP = new HashMap();
    public static final HashMap<DyeColor, RegistryObject<Block>> DYE_COLOR_TO_COMPACT_BARREL_MAP = new HashMap();
    public static final CreativeModeTab COMPACT_STORAGE_ITEM_GROUP = new CreativeModeTab("compact_storage.general"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)COMPACT_CHEST_BLOCKS[1].get(), 1);
        }
    };
    public static final RegistryObject<Item> UPGRADE_ROW_ITEM = ITEM_REGISTER.register("upgrade_row", () -> new StorageUpgradeItem(new Item.Properties().m_41491_(COMPACT_STORAGE_ITEM_GROUP)));
    public static final RegistryObject<Item> UPGRADE_COLUMN_ITEM = ITEM_REGISTER.register("upgrade_column", () -> new StorageUpgradeItem(new Item.Properties().m_41491_(COMPACT_STORAGE_ITEM_GROUP)));
    public static ResourceLocation BACKPACK_GENERIC_IDENTIFIER = new ResourceLocation("compact_storage", "backpack");
    public static final RegistryObject<Item>[] BACKPACK_ITEMS = new RegistryObject[16];
    public static final HashMap<DyeColor, RegistryObject<Item>> DYE_COLOR_TO_BACKPACK_MAP = new HashMap();

    public static Block[] mapRegistryObjectToBlocks(RegistryObject<Block>[] array) {
        Block[] mapped = new Block[array.length];
        for (int i = 0; i < mapped.length; ++i) {
            mapped[i] = (Block)array[i].get();
        }
        return mapped;
    }

    public CompactStorage() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        BLOCK_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEM_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITY_TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        MENU_TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    static {
        for (int i = 0; i < 16; ++i) {
            String dyeName = DyeColor.m_41053_((int)i).m_41065_().toLowerCase();
            DyeColor color = DyeColor.m_41053_((int)i);
            int id = i;
            CompactStorage.COMPACT_CHEST_BLOCKS[i] = BLOCK_REGISTER.register("compact_chest_" + dyeName, () -> new CompactChestBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_).m_60955_().m_60913_(2.0f, 5.0f)));
            ITEM_REGISTER.register("compact_chest_" + dyeName, () -> new BlockItem((Block)COMPACT_CHEST_BLOCKS[id].get(), new Item.Properties().m_41491_(COMPACT_STORAGE_ITEM_GROUP)));
            DYE_COLOR_TO_COMPACT_CHEST_MAP.put(color, COMPACT_CHEST_BLOCKS[i]);
            CompactStorage.BACKPACK_ITEMS[i] = ITEM_REGISTER.register("backpack_" + dyeName, () -> new BackpackItem(new Item.Properties().m_41487_(1).m_41491_(COMPACT_STORAGE_ITEM_GROUP)));
            DYE_COLOR_TO_BACKPACK_MAP.put(color, BACKPACK_ITEMS[i]);
            CompactStorage.COMPACT_BARREL_BLOCKS[i] = BLOCK_REGISTER.register("compact_barrel_" + color, () -> new CompactBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60913_(2.0f, 5.0f)));
            DYE_COLOR_TO_COMPACT_BARREL_MAP.put(color, COMPACT_BARREL_BLOCKS[i]);
            ITEM_REGISTER.register("compact_barrel_" + dyeName, () -> new BlockItem((Block)COMPACT_BARREL_BLOCKS[id].get(), new Item.Properties().m_41491_(COMPACT_STORAGE_ITEM_GROUP)));
        }
    }
}

