/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.render.terrain.color;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.blender.LinearColorBlender;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.StateHolder;

public class LinearFlatColorBlender
extends LinearColorBlender {
    public <T extends StateHolder<O, ?>, O> int[] getColors(BlockAndTintGetter world, BlockPos origin, ModelQuadView quad, ColorSampler<T> sampler, T state) {
        int[] colors = super.getColors(world, origin, quad, sampler, state);
        Arrays.fill(colors, this.getAverageColor(colors));
        return colors;
    }

    private <T> int getAverageColor(int[] colors) {
        int a = Arrays.stream(colors).map(ColorARGB::unpackAlpha).sum();
        int r = Arrays.stream(colors).map(ColorARGB::unpackRed).sum();
        int g = Arrays.stream(colors).map(ColorARGB::unpackGreen).sum();
        int b = Arrays.stream(colors).map(ColorARGB::unpackBlue).sum();
        return ColorARGB.pack((int)(r / colors.length), (int)(g / colors.length), (int)(b / colors.length), (int)(a / colors.length));
    }
}

