/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.client.renderer.model;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.renderer.model.BackfaceBakedQuad;
import cofh.lib.client.renderer.model.RetexturedBakedQuad;
import cofh.lib.util.Constants;
import cofh.thermal.dynamics.client.model.data.DuctModelData;
import cofh.thermal.dynamics.util.TDynConstants;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class DuctBakedModel
implements IDynamicBakedModel {
    private static final boolean DEBUG = Boolean.getBoolean("DuctModel.debug");
    private static final DuctModelData INV_DATA = (DuctModelData)Util.m_137469_((Object)new DuctModelData(), data -> {
        data.setInternalConnection(Direction.UP, true);
        data.setInternalConnection(Direction.DOWN, true);
    });
    private final IModelConfiguration config;
    private final TextureAtlasSprite particle;
    private final Map<Direction, List<BakedQuad>> centerModel;
    private final Map<Direction, List<BakedQuad>> centerFill;
    private final Map<Direction, List<BakedQuad>> sides;
    private final Map<Direction, List<BakedQuad>> fill;
    private final Map<Direction, List<BakedQuad>> connections;
    private final boolean isInventory;
    private final Map<DuctModelData, List<BakedQuad>> modelCache = new HashMap<DuctModelData, List<BakedQuad>>();
    private final Map<TexColorWrapper, Map<Direction, List<BakedQuad>>> centerFillCache = new Object2ObjectOpenHashMap();
    private final Map<TexColorWrapper, Map<Direction, List<BakedQuad>>> fillCache = new Object2ObjectOpenHashMap();
    private final Map<ResourceLocation, Map<Direction, List<BakedQuad>>> attachmentCache = new Object2ObjectOpenHashMap();

    public void clearCache() {
        this.modelCache.clear();
        this.centerFillCache.clear();
        this.fillCache.clear();
        this.attachmentCache.clear();
    }

    public DuctBakedModel(IModelConfiguration config, TextureAtlasSprite particle, EnumMap<Direction, List<BakedQuad>> centerModel, EnumMap<Direction, List<BakedQuad>> centerFill, EnumMap<Direction, List<BakedQuad>> sides, EnumMap<Direction, List<BakedQuad>> fill, EnumMap<Direction, List<BakedQuad>> connections, boolean isInventory) {
        this.config = config;
        this.particle = particle;
        this.centerModel = ImmutableMap.copyOf(centerModel);
        this.centerFill = ImmutableMap.copyOf(centerFill);
        this.sides = ImmutableMap.copyOf(sides);
        this.fill = ImmutableMap.copyOf(fill);
        this.connections = ImmutableMap.copyOf(connections);
        this.isInventory = isInventory;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return Collections.emptyList();
        }
        if (this.isInventory) {
            extraData = INV_DATA;
        }
        if (!(extraData instanceof DuctModelData)) {
            return ImmutableList.of();
        }
        DuctModelData modelData = (DuctModelData)extraData;
        return this.getModelFor(modelData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BakedQuad> getModelFor(DuctModelData modelData) {
        ImmutableList modelQuads = this.modelCache.get(modelData);
        if (!DEBUG && modelQuads != null) {
            return modelQuads;
        }
        Map<DuctModelData, List<BakedQuad>> map = this.modelCache;
        synchronized (map) {
            modelQuads = this.modelCache.get(modelData);
            if (!DEBUG && modelQuads != null) {
                return modelQuads;
            }
            ImmutableList.Builder quads = ImmutableList.builder();
            for (Direction dir : Constants.DIRECTIONS) {
                List<BakedQuad> fillQuads;
                boolean internal = modelData.hasInternalConnection(dir);
                boolean external = modelData.hasExternalConnection(dir);
                ResourceLocation attachment = modelData.getAttachment(dir);
                if (!internal && !external) {
                    fillQuads = this.rebakeFill(this.centerFillCache, this.centerFill, modelData.getFill(), modelData.getFillColor(), dir);
                    quads.addAll(this.filterBlank(this.centerModel.get(dir), false));
                    quads.addAll(this.filterBlank(fillQuads, false));
                    continue;
                }
                quads.addAll(this.filterBlank(this.sides.get(dir), !(fillQuads = this.rebakeFill(this.fillCache, this.fill, modelData.getFill(), modelData.getFillColor(), dir)).isEmpty()));
                quads.addAll(this.filterBlank(fillQuads, false));
                if (!external) continue;
                quads.addAll(this.filterBlank(this.rebakeAttachment(this.attachmentCache, this.connections, attachment, dir), true));
            }
            modelQuads = quads.build();
            this.modelCache.put(new DuctModelData(modelData), (List<BakedQuad>)modelQuads);
            return modelQuads;
        }
    }

    private List<BakedQuad> filterBlank(List<BakedQuad> quads, boolean cullBack) {
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            if (cullBack && quad instanceof BackfaceBakedQuad || quad.m_173410_().m_118413_().equals((Object)TDynConstants.BLANK_TEXTURE)) continue;
            newQuads.add(quad);
        }
        return newQuads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BakedQuad> rebakeFill(Map<TexColorWrapper, Map<Direction, List<BakedQuad>>> cache, Map<Direction, List<BakedQuad>> raw, @Nullable ResourceLocation texture, int color, Direction dir) {
        List<BakedQuad> quads;
        List<BakedQuad> fillQuads = raw.get(dir);
        if (fillQuads.isEmpty()) {
            return ImmutableList.of();
        }
        if (texture == null) {
            return fillQuads;
        }
        Map<Direction, List<BakedQuad>> retextured = cache.get(new TexColorWrapper(texture, color));
        if (retextured != null && (quads = retextured.get(dir)) != null) {
            return quads;
        }
        Map<TexColorWrapper, Map<Direction, List<BakedQuad>>> map = cache;
        synchronized (map) {
            retextured = cache.get(new TexColorWrapper(texture, color));
            if (retextured != null) {
                List<BakedQuad> quads2 = retextured.get(dir);
                if (quads2 != null) {
                    return quads2;
                }
            } else {
                retextured = new HashMap<Direction, List<BakedQuad>>();
                cache.put(new TexColorWrapper(texture, color), retextured);
            }
            TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(texture);
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(fillQuads.size());
            for (BakedQuad quad : fillQuads) {
                newQuads.add((BakedQuad)new RetexturedBakedQuad(RenderHelper.mulColor((BakedQuad)quad, (int)color), sprite));
            }
            retextured.put(dir, newQuads);
            return newQuads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BakedQuad> rebakeAttachment(Map<ResourceLocation, Map<Direction, List<BakedQuad>>> cache, Map<Direction, List<BakedQuad>> raw, @Nullable ResourceLocation texture, Direction dir) {
        List<BakedQuad> quads;
        List<BakedQuad> connQuads = raw.get(dir);
        if (connQuads.isEmpty()) {
            return ImmutableList.of();
        }
        if (texture == null) {
            return connQuads;
        }
        Map<Direction, List<BakedQuad>> retextured = cache.get(texture);
        if (retextured != null && (quads = retextured.get(dir)) != null) {
            return quads;
        }
        Map<ResourceLocation, Map<Direction, List<BakedQuad>>> map = cache;
        synchronized (map) {
            retextured = cache.get(texture);
            if (retextured != null) {
                List<BakedQuad> quads2 = retextured.get(dir);
                if (quads2 != null) {
                    return quads2;
                }
            } else {
                retextured = new HashMap<Direction, List<BakedQuad>>();
                cache.put(texture, retextured);
            }
            TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(texture);
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(connQuads.size());
            for (BakedQuad quad : connQuads) {
                newQuads.add((BakedQuad)new RetexturedBakedQuad(quad, sprite));
            }
            retextured.put(dir, newQuads);
            return newQuads;
        }
    }

    public boolean m_7541_() {
        return this.config.useSmoothLighting();
    }

    public boolean m_7539_() {
        return this.config.isShadedInGui();
    }

    public boolean m_7547_() {
        return this.config.isSideLit();
    }

    public ItemTransforms m_7442_() {
        return this.config.getCameraTransforms();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle;
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private static class TexColorWrapper {
        ResourceLocation texture;
        int color;

        public TexColorWrapper(ResourceLocation texture, int color) {
            this.texture = texture;
            this.color = color;
        }

        public int hashCode() {
            return this.texture.hashCode() + this.color * 31;
        }
    }
}

