/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.util;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.platform.World;

public class Disk {
    private static final long ESTIMATED_SPACE_PER_CHUNK = 7031L;
    private static final double PERCENT_OVERESTIMATE = 1.05;

    private Disk() {
    }

    public static long estimatedSpace(Selection selection) {
        long diameterChunksX = selection.diameterChunksX();
        long diameterChunksZ = selection.diameterChunksZ();
        return (long)(1.05 * (double)(diameterChunksX * diameterChunksZ * 7031L));
    }

    public static long remainingSpace(World world) {
        Optional<Path> regionDirectory = world.getRegionDirectory();
        try {
            if (regionDirectory.isPresent()) {
                return regionDirectory.get().toFile().getUsableSpace();
            }
            Path currentWorkingDirectory = Paths.get("", new String[0]);
            if (Files.exists(currentWorkingDirectory, new LinkOption[0])) {
                return currentWorkingDirectory.toFile().getUsableSpace();
            }
        }
        catch (SecurityException | UnsupportedOperationException | InvalidPathException runtimeException) {
            // empty catch block
        }
        return 0L;
    }
}

