/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;

public class CornersCommand
extends ChunkyCommand {
    public CornersCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        String shape;
        if (args.length < 5) {
            sender.sendMessage("help_corners", new Object[0]);
            return;
        }
        Optional<Double> x1 = Input.tryDoubleSuffixed(args[1]);
        Optional<Double> z1 = Input.tryDoubleSuffixed(args[2]);
        Optional<Double> x2 = Input.tryDoubleSuffixed(args[3]);
        Optional<Double> z2 = Input.tryDoubleSuffixed(args[4]);
        if (!(x1.isPresent() && z1.isPresent() && x2.isPresent() && z2.isPresent())) {
            sender.sendMessage("help_corners", new Object[0]);
            return;
        }
        if (Input.isPastWorldLimit(x1.get()) || Input.isPastWorldLimit(z1.get()) || Input.isPastWorldLimit(x2.get()) || Input.isPastWorldLimit(z2.get())) {
            sender.sendMessage("help_corners", new Object[0]);
            return;
        }
        double centerX = (x1.get() + x2.get()) / 2.0;
        double centerZ = (z1.get() + z2.get()) / 2.0;
        double radiusX = Math.abs(x1.get() - x2.get()) / 2.0;
        double radiusZ = Math.abs(z1.get() - z2.get()) / 2.0;
        this.chunky.getSelection().center(centerX, centerZ).radiusX(radiusX).radiusZ(radiusZ);
        sender.sendMessagePrefixed("format_center", Formatting.number(centerX), Formatting.number(centerZ));
        if (radiusX == radiusZ) {
            sender.sendMessagePrefixed("format_radius", Formatting.number(radiusX));
            shape = "square";
        } else {
            sender.sendMessagePrefixed("format_radii", Formatting.number(radiusX), Formatting.number(radiusZ));
            shape = "rectangle";
        }
        this.chunky.getSelection().shape(shape);
        sender.sendMessagePrefixed("format_shape", shape);
    }
}

