/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import vazkii.quark.base.handler.UndergroundBiomeHandler;

public class TerraBlenderIntegration
implements Supplier<UndergroundBiomeHandler.Proxy> {
    private TBProxy proxy;

    @Override
    public UndergroundBiomeHandler.Proxy get() {
        if (this.proxy == null) {
            this.proxy = new TBProxy();
        }
        return this.proxy;
    }

    class TBProxy
    extends UndergroundBiomeHandler.Proxy {
        TBProxy() {
        }

        @Override
        public void init(ParallelDispatchEvent event) {
            event.enqueueWork(() -> {
                for (UndergroundBiomeHandler.UndergroundBiomeSkeleton skeleton : this.skeletons) {
                    if (!skeleton.module().enabled) continue;
                    Regions.register((Region)new QuarkRegion());
                    return;
                }
            });
        }

        @Override
        public void addUndergroundBiomes(OverworldBiomeBuilder builder, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        }
    }

    class QuarkRegion
    extends Region {
        public QuarkRegion() {
            super(new ResourceLocation("quark", "biome_provider"), RegionType.OVERWORLD, 1);
        }

        public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
            boolean didAnything = false;
            for (UndergroundBiomeHandler.UndergroundBiomeSkeleton skeleton : TerraBlenderIntegration.this.proxy.skeletons) {
                if (!skeleton.module().enabled) continue;
                ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)skeleton.biome());
                mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)skeleton.climate(), (Object)resourceKey));
                didAnything = true;
            }
            if (didAnything) {
                this.addModifiedVanillaOverworldBiomes(mapper, b -> {});
            }
        }
    }
}

