/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.mobs.ai.RaveGoal;
import vazkii.quark.content.mobs.module.CrabsModule;

public class Crab
extends Animal
implements IEntityAdditionalSpawnData {
    public static final int COLORS = 3;
    public static final ResourceLocation CRAB_LOOT_TABLE = new ResourceLocation("quark", "entities/crab");
    private static final EntityDataAccessor<Float> SIZE_MODIFIER = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static int lightningCooldown;
    private Ingredient temptationItems;
    private boolean noSpike;
    private boolean crabRave;
    private BlockPos jukeboxPosition;

    public Crab(EntityType<? extends Crab> type, Level worldIn) {
        this(type, worldIn, 1.0f);
    }

    public Crab(EntityType<? extends Crab> type, Level worldIn, float sizeModifier) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        if (sizeModifier != 1.0f) {
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
    }

    public static boolean spawnPredicate(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(CrabsModule.crabSpawnableTag) && world.m_46803_(pos) > 8;
    }

    public static void rave(LevelAccessor world, BlockPos pos, boolean raving) {
        for (Crab crab : world.m_45976_(Crab.class, new AABB(pos).m_82400_(3.0))) {
            crab.party(pos, raving);
        }
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_8055_(pos.m_7495_()).m_204336_(CrabsModule.crabSpawnableTag) ? 10.0f : world.m_46863_(pos) - 0.5f;
    }

    public boolean m_6040_() {
        return true;
    }

    @Nonnull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE_MODIFIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(VARIANT, (Object)-1);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return QuarkSounds.ENTITY_CRAB_IDLE;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_CRAB_DIE;
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource source) {
        return QuarkSounds.ENTITY_CRAB_HURT;
    }

    protected float m_6431_(@Nonnull Pose pose, EntityDimensions size) {
        return 0.2f * size.f_20378_;
    }

    public float getSizeModifier() {
        return ((Float)this.f_19804_.m_135370_(SIZE_MODIFIER)).floatValue();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new RaveGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public void m_8119_() {
        BlockPos below;
        BlockState belowState;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && (Integer)this.f_19804_.m_135370_(VARIANT) == -1) {
            int variant = 0;
            if (this.f_19796_.nextBoolean()) {
                variant += this.f_19796_.nextInt(2) + 1;
            }
            if (this.f_19796_.nextInt(3) == 0) {
                variant += 3;
            }
            this.f_19804_.m_135381_(VARIANT, (Object)variant);
        }
        this.f_19793_ = this.f_19798_ ? 1.0f : 0.6f;
        if (lightningCooldown > 0) {
            --lightningCooldown;
            this.m_20095_();
        }
        Vec3 pos = this.m_20182_();
        if (this.isRaving() && (this.jukeboxPosition == null || this.jukeboxPosition.m_123331_(new Vec3i(pos.f_82479_, pos.f_82480_, pos.f_82481_)) > 24.0 || this.f_19853_.m_8055_(this.jukeboxPosition).m_60734_() != Blocks.f_50131_)) {
            this.party(null, false);
        }
        if (this.isRaving() && this.f_19853_.f_46443_ && this.f_19797_ % 10 == 0 && (belowState = this.f_19853_.m_8055_(below = this.m_142538_().m_7495_())).m_60767_() == Material.f_76317_) {
            this.f_19853_.m_46796_(2001, below, Block.m_49956_((BlockState)belowState));
        }
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getSizeModifier());
    }

    public boolean m_6063_() {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_6673_(@Nonnull DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_19306_ || this.getSizeModifier() > 1.0f && source.m_19384_();
    }

    public boolean m_5825_() {
        return super.m_5825_() || this.getSizeModifier() > 1.0f;
    }

    public void m_8038_(@Nonnull ServerLevel sworld, @Nonnull LightningBolt lightningBolt) {
        if (lightningCooldown > 0 || this.f_19853_.f_46443_) {
            return;
        }
        float sizeMod = this.getSizeModifier();
        if (sizeMod <= 15.0f) {
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Lightning Bonus", 0.5, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("Lightning Debuff", -0.05, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier("Lightning Bonus", 0.125, AttributeModifier.Operation.ADDITION));
            float sizeModifier = Math.min(sizeMod + 1.0f, 16.0f);
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
            this.m_6210_();
            lightningCooldown = 150;
        }
    }

    public void m_7334_(@Nonnull Entity entityIn) {
        if (this.getSizeModifier() <= 1.0f) {
            super.m_7334_(entityIn);
        }
    }

    protected void m_7324_(@Nonnull Entity entityIn) {
        super.m_7324_(entityIn);
        if (this.f_19853_.m_46791_() != Difficulty.PEACEFUL && !this.noSpike && entityIn instanceof LivingEntity && !(entityIn instanceof Crab)) {
            entityIn.m_6469_(DamageSource.f_19314_, 1.0f);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && this.getTemptationItems().test(stack);
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_, Items.f_42581_}), Ingredient.m_204132_((TagKey)ItemTags.f_13156_)}));
        }
        return this.temptationItems;
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel sworld, @Nonnull AgeableMob other) {
        return new Crab(CrabsModule.crabType, this.f_19853_);
    }

    @Nonnull
    protected ResourceLocation m_7582_() {
        return CRAB_LOOT_TABLE;
    }

    public int getVariant() {
        return Math.max(0, (Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public void party(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.crabRave = isPartying;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6818_(@Nonnull BlockPos pos, boolean isPartying) {
        this.party(pos, isPartying);
    }

    public boolean isRaving() {
        return this.crabRave;
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> parameter) {
        if (parameter.equals(SIZE_MODIFIER)) {
            this.m_6210_();
        }
        super.m_7350_(parameter);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getSizeModifier());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(buffer.readFloat()));
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        lightningCooldown = compound.m_128451_("LightningCooldown");
        this.noSpike = compound.m_128471_("NoSpike");
        if (compound.m_128441_("EnemyCrabRating")) {
            float sizeModifier = compound.m_128457_("EnemyCrabRating");
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        if (compound.m_128441_("Variant")) {
            this.f_19804_.m_135381_(VARIANT, (Object)compound.m_128451_("Variant"));
        }
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("EnemyCrabRating", this.getSizeModifier());
        compound.m_128405_("LightningCooldown", lightningCooldown);
        compound.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        compound.m_128379_("NoSpike", this.noSpike);
    }
}

