/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.item.boat;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import vazkii.quark.base.handler.WoodSetHandler;

public class QuarkBoat
extends Boat {
    private static final Map<String, QuarkBoatType> quarkBoatTypes = new HashMap<String, QuarkBoatType>();
    private static final EntityDataAccessor<String> DATA_QUARK_TYPE = SynchedEntityData.m_135353_(QuarkBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public QuarkBoat(EntityType<? extends Boat> entityType, Level world) {
        super(entityType, world);
    }

    public QuarkBoat(Level world, double x, double y, double z) {
        this(WoodSetHandler.quarkBoatEntityType, world);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public static void addQuarkBoatType(String name, QuarkBoatType type) {
        quarkBoatTypes.put(name, type);
    }

    public static QuarkBoatType getTypeRecord(String name) {
        return quarkBoatTypes.get(name);
    }

    public static Stream<String> boatTypes() {
        return quarkBoatTypes.keySet().stream();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_QUARK_TYPE, (Object)"blossom");
    }

    public String getQuarkBoatType() {
        return (String)this.f_19804_.m_135370_(DATA_QUARK_TYPE);
    }

    public void setQuarkBoatType(String type) {
        this.f_19804_.m_135381_(DATA_QUARK_TYPE, (Object)type);
    }

    protected void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("QuarkType", this.getQuarkBoatType());
    }

    protected void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("QuarkType", 8)) {
            this.setQuarkBoatType(tag.m_128461_("QuarkType"));
        }
    }

    public ItemEntity m_19998_(ItemLike itemLike) {
        if (itemLike.m_5456_().getRegistryName().m_135815_().contains("_planks")) {
            return super.m_19998_((ItemLike)QuarkBoat.getTypeRecord((String)this.getQuarkBoatType()).planks);
        }
        return super.m_19998_(itemLike);
    }

    @Nonnull
    public Item m_38369_() {
        return QuarkBoat.getTypeRecord((String)this.getQuarkBoatType()).boat;
    }

    @Nonnull
    public Boat.Type m_38387_() {
        return Boat.Type.OAK;
    }

    public void m_38332_(@Nonnull Boat.Type type) {
    }

    public record QuarkBoatType(Item boat, Block planks) {
    }
}

