/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.ChangeListener;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.mod.util.OrderedCompoundTag;
import dev.latvian.mods.rhino.mod.util.StringBuilderAppendable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class MapJS
extends LinkedHashMap<String, Object>
implements StringBuilderAppendable,
ChangeListener<Object>,
Copyable,
JsonSerializable,
NBTSerializable {
    public ChangeListener<MapJS> changeListener;

    @Nullable
    public static MapJS of(@Nullable Object o) {
        Object o1 = UtilsJS.wrap(o, JSObjectType.MAP);
        return o1 instanceof MapJS ? (MapJS)o1 : null;
    }

    @Deprecated
    @Nullable
    public static CompoundTag nbt(@Nullable Object map) {
        return NBTUtils.toTagCompound((Object)map);
    }

    @Nullable
    public static JsonObject json(@Nullable Object map) {
        if (map instanceof JsonObject) {
            JsonObject json = (JsonObject)map;
            return json;
        }
        if (map instanceof CharSequence) {
            try {
                return (JsonObject)JsonIO.GSON.fromJson(map.toString(), JsonObject.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        MapJS m = MapJS.of(map);
        return m == null ? null : m.toJson();
    }

    public MapJS() {
        this(0);
    }

    public MapJS(int s) {
        super(s);
    }

    public int getLength() {
        return this.size();
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        this.appendString(builder);
        return builder.toString();
    }

    private boolean isWordChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    private boolean isWordString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (this.isWordChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void appendString(StringBuilder builder) {
        if (this.isEmpty()) {
            builder.append("{}");
            return;
        }
        builder.append('{');
        boolean first = true;
        for (Map.Entry entry : this.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            if (this.isWordString((String)entry.getKey())) {
                builder.append((String)entry.getKey());
            } else {
                builder.append('\"');
                builder.append(((String)entry.getKey()).replace("\"", "\\\""));
                builder.append('\"');
            }
            builder.append(':');
            if (entry.getValue() instanceof CharSequence) {
                builder.append('\"');
                builder.append(entry.getValue().toString().replace("\"", "\\\""));
                builder.append('\"');
                continue;
            }
            Object o = entry.getValue();
            if (o instanceof StringBuilderAppendable) {
                ((StringBuilderAppendable)o).appendString(builder);
                continue;
            }
            builder.append(o);
        }
        builder.append('}');
    }

    public MapJS copy() {
        MapJS map = new MapJS(this.size());
        for (Map.Entry entry : this.entrySet()) {
            map.put((String)entry.getKey(), UtilsJS.copy(entry.getValue()));
        }
        return map;
    }

    protected boolean setChangeListener(@Nullable Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof MapJS) {
            MapJS map = (MapJS)v;
            map.changeListener = this::onChanged;
        } else if (v instanceof ListJS) {
            ListJS list = (ListJS)v;
            list.changeListener = this::onChanged;
        }
        return true;
    }

    public void onChanged(@Nullable Object o) {
        if (this.changeListener != null) {
            this.changeListener.onChanged((Object)this);
        }
    }

    @Nullable
    private Object withChangeListener(Object value) {
        Object v = UtilsJS.wrap(value, JSObjectType.ANY);
        if (v instanceof Double) {
            long i;
            Double d = (Double)v;
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return d;
            }
            if (d <= 2.147483647E9 && d >= -2.147483648E9) {
                int i2 = d.intValue();
                if ((double)i2 == d) {
                    return i2;
                }
            } else if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18 && (double)(i = d.longValue()) == d) {
                return i;
            }
            return d;
        }
        if (this.setChangeListener(v)) {
            return v;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object v = this.withChangeListener(value);
        if (v != null) {
            Object o = super.put(key, v);
            this.onChanged(null);
            return o;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null || m.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            Object v = this.withChangeListener(entry.getValue());
            if (v == null) continue;
            super.put(entry.getKey().toString(), v);
        }
        this.onChanged(null);
    }

    @Override
    public void clear() {
        super.clear();
        this.onChanged(null);
    }

    @Override
    @Nullable
    public Object remove(Object key) {
        Object o = super.remove(key);
        if (o != null) {
            this.onChanged(null);
        }
        return o;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry entry : this.entrySet()) {
            JsonElement e = JsonIO.of(entry.getValue());
            json.add((String)entry.getKey(), e);
        }
        return json;
    }

    public CompoundTag toNBT() {
        OrderedCompoundTag nbt = new OrderedCompoundTag();
        for (Map.Entry entry : this.entrySet()) {
            Tag nbt1 = NBTUtils.toTag(entry.getValue());
            if (nbt1 == null) continue;
            nbt.m_128365_((String)entry.getKey(), nbt1);
        }
        return nbt;
    }

    public MapJS getOrNewMap(String id) {
        MapJS map = MapJS.of(this.get(id));
        if (map == null) {
            map = new MapJS();
            this.put(id, (Object)map);
        }
        return map;
    }

    public ListJS getOrNewList(String id) {
        ListJS list = ListJS.of(this.get(id));
        if (list == null) {
            list = new ListJS();
            this.put(id, (Object)list);
        }
        return list;
    }

    public boolean containsAll(@Nullable MapJS other) {
        if (other == null || other.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : other.entrySet()) {
            if (Objects.equals(entry.getValue(), this.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(@Nullable MapJS other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : other.entrySet()) {
            if (!Objects.equals(entry.getValue(), this.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }
}

