/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class MatchAnyIngredientJS
implements IngredientJS,
Consumer<IngredientJS> {
    public final List<IngredientJS> ingredients = new ArrayList<IngredientJS>();

    public MatchAnyIngredientJS add(@Nullable Object ingredient) {
        IngredientJS i = IngredientJS.of(ingredient);
        if (i != ItemStackJS.EMPTY) {
            this.ingredients.add(i);
        }
        return this;
    }

    public MatchAnyIngredientJS addAll(Object ingredients) {
        for (Object o : ListJS.orSelf(ingredients)) {
            this.add(o);
        }
        return this;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (IngredientJS ingredient : this.ingredients) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (IngredientJS ingredient : this.ingredients) {
            if (!ingredient.testVanilla(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanillaItem(Item item) {
        if (item == Items.f_41852_) {
            return false;
        }
        for (IngredientJS ingredient : this.ingredients) {
            if (!ingredient.testVanillaItem(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        for (IngredientJS ingredient : this.ingredients) {
            set.addAll(ingredient.getStacks());
        }
        return set;
    }

    @Override
    public Set<Item> getVanillaItems() {
        LinkedHashSet<Item> set = new LinkedHashSet<Item>();
        for (IngredientJS ingredient : this.ingredients) {
            set.addAll(ingredient.getVanillaItems());
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        for (IngredientJS i : this.ingredients) {
            if (i.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(IngredientJS ingredient) {
        this.ingredients.add(ingredient);
    }

    @Override
    public IngredientJS copy() {
        MatchAnyIngredientJS i = new MatchAnyIngredientJS();
        for (IngredientJS in : this.ingredients) {
            i.ingredients.add(in.copy());
        }
        return i;
    }

    public String toString() {
        return this.ingredients.toString();
    }

    @Override
    public boolean isInvalidRecipeIngredient() {
        for (IngredientJS i : this.ingredients) {
            if (!i.isInvalidRecipeIngredient()) continue;
            return true;
        }
        return false;
    }
}

