/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.block;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.api.provider.BalmProviderHolder;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface BalmBlockEntityContract
extends BalmProviderHolder {
    default public void writeUpdateTag(CompoundTag tag) {
    }

    default public void sync() {
        BlockEntity self = (BlockEntity)this;
        if (self.m_58904_() != null && !self.m_58904_().f_46443_) {
            ((ServerLevel)self.m_58904_()).m_7726_().m_8450_(self.m_58899_());
        }
    }

    default public Packet<ClientGamePacketListener> createUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)((BlockEntity)this), BalmBlockEntityContract::createUpdateTag);
    }

    default public CompoundTag createUpdateTag() {
        BlockEntity self = (BlockEntity)this;
        return BalmBlockEntityContract.createUpdateTag(self);
    }

    private static CompoundTag createUpdateTag(BlockEntity blockEntity) {
        CompoundTag tag = new CompoundTag();
        if (blockEntity instanceof BalmBlockEntityContract) {
            BalmBlockEntityContract balmBlockEntity = (BalmBlockEntityContract)blockEntity;
            balmBlockEntity.writeUpdateTag(tag);
        }
        return tag;
    }

    public <T> T getProvider(Class<T> var1);

    default public void buildProviders(List<BalmProviderHolder> providers) {
        providers.add(this);
        BalmBlockEntityContract balmBlockEntityContract = this;
        if (balmBlockEntityContract instanceof BalmContainerProvider) {
            final BalmContainerProvider containerProvider = (BalmContainerProvider)((Object)balmBlockEntityContract);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    Container container = containerProvider.getContainer();
                    if (container != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<Container>(Container.class, container)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<Direction, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (Direction direction : Direction.values()) {
                        Container container = containerProvider.getContainer(direction);
                        if (container == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<Container>(Container.class, container)));
                    }
                    return providers;
                }
            });
        }
        if ((balmBlockEntityContract = this) instanceof BalmFluidTankProvider) {
            final BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)((Object)balmBlockEntityContract);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    FluidTank fluidTank = fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<FluidTank>(FluidTank.class, fluidTank)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<Direction, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (Direction direction : Direction.values()) {
                        FluidTank fluidTank = fluidTankProvider.getFluidTank(direction);
                        if (fluidTank == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<FluidTank>(FluidTank.class, fluidTank)));
                    }
                    return providers;
                }
            });
        }
        if ((balmBlockEntityContract = this) instanceof BalmEnergyStorageProvider) {
            final BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)((Object)balmBlockEntityContract);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage();
                    if (energyStorage != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<EnergyStorage>(EnergyStorage.class, energyStorage)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<Direction, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (Direction direction : Direction.values()) {
                        EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage(direction);
                        if (energyStorage == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<EnergyStorage>(EnergyStorage.class, energyStorage)));
                    }
                    return providers;
                }
            });
        }
    }
}

