/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.math.NumberUtils;

public class PneumaticCraftUtils {
    private static final BlockPos INVALID_POS = new BlockPos(0, Integer.MIN_VALUE, 0);
    private static final int MAX_CHAR_PER_LINE = 45;
    private static final int[] DYE_COLORS = new int[DyeColor.values().length];

    public static List<? extends Component> splitStringComponent(String text) {
        return PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(text, 45));
    }

    public static List<? extends Component> splitStringComponent(String text, int maxCharPerLine) {
        return PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(text, maxCharPerLine));
    }

    public static List<String> splitString(String text, int maxCharPerLine) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(text.length());
        String format = "";
        for (String para : text.split(Pattern.quote("${br}"))) {
            StringTokenizer tok = new StringTokenizer(para, " ");
            int lineLen = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                for (String word : Splitter.fixedLength((int)maxCharPerLine).split((CharSequence)token)) {
                    int idx = word.lastIndexOf("\u00a7");
                    if (idx >= 0 && idx < word.length() - 1) {
                        format = word.substring(idx, idx + 2);
                        lineLen -= 2;
                    }
                    if (lineLen + word.length() > maxCharPerLine) {
                        result.add(builder.toString());
                        builder.delete(0, builder.length());
                        builder.append(format);
                        lineLen = 0;
                    } else if (lineLen > 0) {
                        builder.append(" ");
                        ++lineLen;
                    }
                    builder.append(word);
                    lineLen += word.length();
                }
            }
            result.add(builder.toString());
            builder.delete(0, builder.length());
            builder.append(format);
        }
        return result;
    }

    public static List<String> splitString(String text) {
        return PneumaticCraftUtils.splitString(text, 45);
    }

    public static List<? extends Component> asStringComponent(List<String> l) {
        return l.stream().map(TextComponent::new).toList();
    }

    public static String convertTicksToMinutesAndSeconds(long ticks, boolean fraction) {
        String part = "" + ticks % 20L * 5L;
        if (part.length() < 2) {
            part = "0" + part;
        }
        if ((ticks /= 20L) < 60L) {
            return ticks + (String)(fraction ? "." + part : "") + "s";
        }
        return ticks / 60L + "m " + ticks % 60L + "s";
    }

    public static String convertAmountToString(int amount) {
        if (amount < 10000) {
            return NumberFormat.getNumberInstance(Locale.getDefault()).format(amount);
        }
        if (amount < 1000000) {
            return amount / 1000 + "K";
        }
        return amount / 1000000 + "M";
    }

    public static String roundNumberTo(double value, int decimals) {
        return String.format("%." + decimals + "f", PneumaticCraftUtils.roundNumberToDouble(value, decimals));
    }

    public static double roundNumberToDouble(double value, int decimals) {
        return new BigDecimal(value).setScale(decimals, RoundingMode.HALF_DOWN).doubleValue();
    }

    public static boolean epsilonEquals(float f1, float f2) {
        return PneumaticCraftUtils.epsilonEquals(f1, f2, 1.0E-4f);
    }

    public static boolean epsilonEquals(float f1, float f2, float maxDifference) {
        return Math.abs(f1 - f2) < maxDifference;
    }

    public static boolean epsilonEquals(double d1, double d2) {
        return PneumaticCraftUtils.epsilonEquals(d1, d2, 1.0E-4);
    }

    public static boolean epsilonEquals(double d1, double d2, double maxDifference) {
        return Math.abs(d1 - d2) < maxDifference;
    }

    public static List<Component> summariseItemStacks(List<Component> textList, ItemStack[] originalStacks) {
        return PneumaticCraftUtils.summariseItemStacks(textList, originalStacks, Symbols.bullet().getString());
    }

    public static List<Component> summariseItemStacks(List<Component> textList, ItemStack[] originalStacks, String prefix) {
        ItemStack[] stacks = Arrays.copyOf(originalStacks, originalStacks.length);
        Arrays.sort(stacks, (o1, o2) -> o1.m_41786_().getString().compareToIgnoreCase(o2.m_41786_().getString()));
        int itemCount = 0;
        ItemStack prevItemStack = ItemStack.f_41583_;
        List<ItemStack> prevInventoryItems = null;
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            if (!stack.m_41656_(prevItemStack) || prevInventoryItems != null && prevInventoryItems.size() > 0) {
                if (!prevItemStack.m_41619_()) {
                    PneumaticCraftUtils.addText(textList, prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.m_41786_().getString());
                }
                if (prevInventoryItems != null) {
                    PneumaticCraftUtils.summariseItemStacks(textList, prevInventoryItems.toArray(new ItemStack[0]), prefix + "\u21b3 ");
                }
                prevItemStack = stack;
                itemCount = stack.m_41613_();
            } else {
                itemCount += stack.m_41613_();
            }
            prevInventoryItems = ItemRegistry.getInstance().getStacksInItem(stack);
        }
        if (itemCount > 0 && !prevItemStack.m_41619_()) {
            PneumaticCraftUtils.addText(textList, prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.m_41786_().getString());
            PneumaticCraftUtils.summariseItemStacks(textList, prevInventoryItems.toArray(new ItemStack[0]), prefix + "\u21b3 ");
        }
        return textList;
    }

    private static void addText(List<Component> l, String s) {
        l.add((Component)new TextComponent(s));
    }

    public static String getPage(String urlString) throws IOException {
        StringBuilder all = new StringBuilder();
        URL myUrl = new URL(urlString);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(myUrl.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                all.append(line).append(System.getProperty("line.separator"));
            }
        }
        return all.toString();
    }

    public static double distBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(PneumaticCraftUtils.distBetweenSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetweenSq((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, x, y, z);
    }

    public static double distBetweenSq(BlockPos pos1, BlockPos pos2) {
        return PneumaticCraftUtils.distBetweenSq(pos1.m_123341_(), pos1.m_123342_(), pos1.m_123343_(), pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_());
    }

    public static double distBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distBetweenSq(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public static double distBetween(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, x, y, z);
    }

    public static double distBetween(Vec3i pos1, Vec3i pos2) {
        return PneumaticCraftUtils.distBetween(pos1, (double)pos2.m_123341_() + 0.5, (double)pos2.m_123342_() + 0.5, (double)pos2.m_123343_() + 0.5);
    }

    public static boolean doesItemMatchFilter(@Nonnull ItemStack filterStack, @Nonnull ItemStack stack, boolean checkDurability, boolean checkNBT, boolean checkModSimilarity) {
        if (filterStack.m_41619_() && stack.m_41619_()) {
            return true;
        }
        if (filterStack.m_41619_() || stack.m_41619_()) {
            return false;
        }
        if (checkModSimilarity) {
            String mod1 = filterStack.m_41720_().getRegistryName().m_135827_();
            String mod2 = stack.m_41720_().getRegistryName().m_135827_();
            return mod1.equals(mod2);
        }
        Item item = filterStack.m_41720_();
        if (item instanceof IFilteringItem) {
            IFilteringItem f = (IFilteringItem)item;
            return f.matchFilter(filterStack, stack);
        }
        item = stack.m_41720_();
        if (item instanceof IFilteringItem) {
            IFilteringItem f = (IFilteringItem)item;
            return f.matchFilter(stack, filterStack);
        }
        if (filterStack.m_41720_() != stack.m_41720_()) {
            return false;
        }
        boolean durabilityOK = !checkDurability || filterStack.m_41776_() > 0 && filterStack.m_41773_() == stack.m_41773_();
        boolean nbtOK = !checkNBT || ItemStack.m_41658_((ItemStack)filterStack, (ItemStack)stack);
        return durabilityOK && nbtOK;
    }

    public static boolean isBlockLiquid(Block block) {
        return block instanceof LiquidBlock;
    }

    public static void dropItemOnGround(ItemStack stack, Level world, BlockPos pos) {
        PneumaticCraftUtils.dropItemOnGround(stack, world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static void dropItemOnGround(ItemStack stack, Level world, double x, double y, double z) {
        float dX = world.f_46441_.nextFloat() * 0.8f + 0.1f;
        float dY = world.f_46441_.nextFloat() * 0.8f + 0.1f;
        float dZ = world.f_46441_.nextFloat() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, x + (double)dX, y + (double)dY, z + (double)dZ, stack.m_41777_());
        if (stack.m_41782_()) {
            entityItem.m_32055_().m_41751_(Objects.requireNonNull(stack.m_41783_()).m_6426_());
        }
        float factor = 0.05f;
        entityItem.m_20334_(world.f_46441_.nextGaussian() * (double)factor, world.f_46441_.nextGaussian() * (double)factor + 0.2, world.f_46441_.nextGaussian() * (double)factor);
        world.m_7967_((Entity)entityItem);
    }

    public static void dropItemOnGroundPrecisely(ItemStack stack, Level world, double x, double y, double z) {
        ItemEntity entityItem = new ItemEntity(world, x, y, z, stack.m_41777_());
        if (stack.m_41782_()) {
            entityItem.m_32055_().m_41751_(Objects.requireNonNull(stack.m_41783_()).m_6426_());
        }
        entityItem.m_20334_(0.0, 0.0, 0.0);
        world.m_7967_((Entity)entityItem);
    }

    public static ServerPlayer getPlayerFromId(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
    }

    public static ServerPlayer getPlayerFromName(String name) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(name);
    }

    public static boolean isPlayerOp(Player player) {
        return player.m_20310_(2);
    }

    public static boolean tryPlaceBlock(Level w, BlockPos pos, Player player, Direction face, BlockState newState) {
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)w.m_46472_(), (LevelAccessor)w, (BlockPos)pos);
        if (!ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)snapshot, (Direction)face)) {
            w.m_46597_(pos, newState);
            return true;
        }
        return false;
    }

    public static Mob createDummyEntity(Player player) {
        Zombie dummy = new Zombie(player.f_19853_){};
        dummy.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        return dummy;
    }

    public static boolean consumeInventoryItem(Inventory inv, Item item) {
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            if (((ItemStack)inv.f_35974_.get(i)).m_41720_() != item) continue;
            ((ItemStack)inv.f_35974_.get(i)).m_41774_(1);
            if (((ItemStack)inv.f_35974_.get(i)).m_41613_() <= 0) {
                inv.f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
            return true;
        }
        return false;
    }

    public static void collectNonEmptyItems(IItemHandler handler, NonNullList<ItemStack> items) {
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).m_41619_()) continue;
                items.add((Object)handler.getStackInSlot(i));
            }
        }
    }

    public static boolean consumeInventoryItem(Inventory inv, ItemStack stack) {
        int toConsume = stack.m_41613_();
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            int consumed;
            ItemStack invStack = (ItemStack)inv.f_35974_.get(i);
            if (ItemStack.m_41746_((ItemStack)invStack, (ItemStack)stack)) {
                consumed = Math.min(invStack.m_41613_(), stack.m_41613_());
                invStack.m_41774_(consumed);
            } else {
                consumed = invStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> {
                    for (int j = 0; j < h.getSlots(); ++j) {
                        ItemStack invStack2 = h.getStackInSlot(j);
                        if (!ItemStack.m_41746_((ItemStack)invStack2, (ItemStack)stack)) continue;
                        int extracted = Math.min(invStack2.m_41613_(), stack.m_41613_());
                        ItemStack s = h.extractItem(j, extracted, false);
                        return s.m_41613_();
                    }
                    return 0;
                }).orElse(0);
            }
            if ((toConsume -= consumed) > 0) continue;
            return true;
        }
        return toConsume <= 0;
    }

    public static TranslatableComponent xlate(String s, Object ... args) {
        return new TranslatableComponent(s, args);
    }

    public static Component dyeColorDesc(int c) {
        return new TranslatableComponent("color.minecraft." + DyeColor.m_41053_((int)c).m_41065_()).m_130940_(ChatFormatting.BOLD);
    }

    public static void copyItemHandler(IItemHandler source, ItemStackHandler dest, int maxSlots) {
        int nSlots = Math.min(maxSlots, source.getSlots());
        dest.setSize(nSlots);
        for (int i = 0; i < nSlots; ++i) {
            dest.setStackInSlot(i, source.getStackInSlot(i).m_41777_());
        }
    }

    public static void copyItemHandler(IItemHandler source, ItemStackHandler dest) {
        PneumaticCraftUtils.copyItemHandler(source, dest, source.getSlots());
    }

    public static String posToString(@Nullable BlockPos pos) {
        return PneumaticCraftUtils.isValidPos(pos) ? String.format("%d, %d, %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) : "-";
    }

    public static boolean isValidPos(@Nullable BlockPos pos) {
        return pos != null && pos != INVALID_POS;
    }

    public static BlockPos invalidPos() {
        return INVALID_POS;
    }

    public static <T extends BlockEntity> Optional<T> getTileEntityAt(BlockGetter w, BlockPos pos, Class<T> cls) {
        BlockEntity te;
        if (w != null && pos != null && (te = w.m_7702_(pos)) != null && cls.isAssignableFrom(te.getClass())) {
            return Optional.of(te);
        }
        return Optional.empty();
    }

    public static boolean fillTankWithOrb(IFluidHandler handler, ExperienceOrb orb, IFluidHandler.FluidAction action) {
        int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
        int fluidAmount = orb.m_20801_() * ratio;
        FluidStack toFill = new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), fluidAmount);
        int filled = handler.fill(toFill, action);
        if (filled > 0 && filled < fluidAmount && action.execute()) {
            orb.f_20770_ -= Math.max(1, filled / ratio);
        }
        return filled == fluidAmount;
    }

    public static double getPlayerReachDistance(Player player) {
        AttributeInstance attr;
        if (player != null && (attr = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            return attr.m_22135_() + 1.0;
        }
        return 4.5;
    }

    public static boolean canPlayerReach(Player player, BlockPos pos) {
        if (player == null) {
            return false;
        }
        double dist = PneumaticCraftUtils.getPlayerReachDistance(player);
        return player.m_20238_(Vec3.m_82512_((Vec3i)pos)) <= dist * dist;
    }

    public static boolean isInteger(String str) {
        if (str.isEmpty() || str.equals("-")) {
            return true;
        }
        if (str.startsWith("-")) {
            str = str.substring(1);
        }
        return NumberUtils.isDigits((String)str);
    }

    public static boolean isNumber(String str) {
        if (((String)str).isEmpty() || ((String)str).equals("-")) {
            return true;
        }
        if (((String)str).startsWith("-")) {
            str = ((String)str).substring(1);
        }
        if (((String)str).endsWith(".")) {
            str = (String)str + "0";
        }
        return NumberUtils.isParsable((String)str);
    }

    public static ResourceLocation modDefaultedRL(String str) {
        return str.indexOf(58) > 0 ? new ResourceLocation(str) : new ResourceLocation("pneumaticcraft", str);
    }

    public static String modDefaultedString(ResourceLocation rl) {
        return rl.m_135827_().equals("pneumaticcraft") ? rl.m_135815_() : rl.toString();
    }

    public static int getDyeColorAsRGB(DyeColor dyeColor) {
        return DYE_COLORS[dyeColor.m_41060_()];
    }

    public static Component getBlockNameAt(Level level, BlockPos pos) {
        return level.m_46749_(pos) ? new TranslatableComponent(level.m_8055_(pos).m_60734_().m_7705_()) : TextComponent.f_131282_.m_6879_();
    }

    public static CompoundTag copyNBTWithout(@Nonnull CompoundTag nbt, @Nonnull String skip) {
        CompoundTag newNBT = new CompoundTag();
        for (String key : nbt.m_128431_()) {
            Tag subTag;
            if (skip.equals(key) || (subTag = nbt.m_128423_(key)) == null) continue;
            newNBT.m_128365_(key, subTag.m_6426_());
        }
        return newNBT.m_128456_() ? new CompoundTag() : newNBT;
    }

    public static Set<TagKey<Item>> itemTags(Item item) {
        return Registry.f_122827_.m_206081_((ResourceKey)Registry.f_122827_.m_7854_((Object)item).orElseThrow()).m_203616_().collect(Collectors.toSet());
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            float[] rgb = color.m_41068_();
            PneumaticCraftUtils.DYE_COLORS[color.m_41060_()] = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
        }
    }
}

