/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.PriorityQueue;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticsModule;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class LogisticsModule
extends AbstractTubeModule
implements INetworkedModule {
    private AbstractLogisticsFrameEntity cachedFrame;
    private int colorChannel;
    private int ticksSinceAction = -1;
    private int ticksSinceNotEnoughAir = -1;
    private int ticksUntilNextCycle;
    private boolean powered;

    public LogisticsModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.LOGISTICS_MODULE.get();
    }

    public int getTicksSinceAction() {
        return this.ticksSinceAction;
    }

    public int getTicksSinceNotEnoughAir() {
        return this.ticksSinceNotEnoughAir;
    }

    @Override
    public double getWidth() {
        return 13.0;
    }

    @Override
    protected double getHeight() {
        return 4.5;
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int colorChannel) {
        this.colorChannel = colorChannel;
        this.setChanged();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    public boolean hasPower() {
        return this.powered;
    }

    public void onUpdatePacket(int status, int colorChannel) {
        boolean bl = this.powered = status > 0;
        if (status == 2) {
            this.ticksSinceAction = 0;
        }
        if (status == 3) {
            this.ticksSinceNotEnoughAir = 0;
        }
        this.colorChannel = colorChannel;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128379_("powered", this.powered);
        nbt.m_128344_("colorChannel", (byte)this.colorChannel);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.powered = nbt.m_128471_("powered");
        this.colorChannel = nbt.m_128445_("colorChannel");
    }

    public AbstractLogisticsFrameEntity getFrame() {
        ISemiBlock semiBlock;
        if (this.cachedFrame == null && (semiBlock = SemiblockTracker.getInstance().getSemiblock(this.getTube().m_58904_(), this.getTube().m_58899_().m_142300_(this.dir), this.dir.m_122424_())) instanceof AbstractLogisticsFrameEntity) {
            this.cachedFrame = (AbstractLogisticsFrameEntity)semiBlock;
        }
        return this.cachedFrame;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        DyeColor color = DyeColor.getColor((ItemStack)player.m_21120_(hand));
        if (color != null) {
            int colorId = color.m_41060_();
            if (!player.f_19853_.f_46443_) {
                this.setColorChannel(colorId);
                NetworkHandler.sendToAllTracking((Object)new PacketUpdateLogisticsModule(this, 0), this.getTube());
                if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue() && !player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
            }
            return true;
        }
        return super.onActivated(player, hand);
    }

    @Override
    protected void tickCommon() {
        super.tickCommon();
        if (this.cachedFrame != null && !this.cachedFrame.isValid()) {
            this.cachedFrame = null;
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.powered != (double)this.getTube().getPressure() >= (Double)ConfigHelper.common().logistics.minPressure.get()) {
            this.powered = !this.powered;
            NetworkHandler.sendToAllTracking((Object)new PacketUpdateLogisticsModule(this, 0), this.getTube());
        }
        if (--this.ticksUntilNextCycle <= 0) {
            LogisticsManager manager = new LogisticsManager();
            Int2ObjectOpenHashMap frame2module = new Int2ObjectOpenHashMap();
            for (AbstractTubeModule module : ModuleNetworkManager.getInstance(this.getTube().nonNullLevel()).getConnectedModules(this)) {
                LogisticsModule logistics;
                if (!module.isValid() || !(module instanceof LogisticsModule) || (logistics = (LogisticsModule)module).getColorChannel() != this.getColorChannel()) continue;
                logistics.ticksUntilNextCycle = 100;
                if (!logistics.hasPower() || logistics.getFrame() == null) continue;
                frame2module.put(logistics.getFrame().m_142049_(), logistics);
                manager.addLogisticFrame(logistics.getFrame());
            }
            PriorityQueue<LogisticsManager.LogisticsTask> tasks = manager.getTasks(null, false);
            for (LogisticsManager.LogisticsTask task : tasks) {
                if (!task.isStillValid(task.transportingItem.m_41619_() ? task.transportingFluid : task.transportingItem)) continue;
                if (!task.transportingItem.m_41619_()) {
                    this.handleItems((LogisticsModule)frame2module.get(task.provider.m_142049_()), (LogisticsModule)frame2module.get(task.requester.m_142049_()), task);
                    continue;
                }
                this.handleFluids((LogisticsModule)frame2module.get(task.provider.m_142049_()), (LogisticsModule)frame2module.get(task.requester.m_142049_()), task);
            }
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.ticksSinceAction >= 0) {
            ++this.ticksSinceAction;
            if (this.ticksSinceAction > 3) {
                this.ticksSinceAction = -1;
            }
        }
        if (this.ticksSinceNotEnoughAir >= 0) {
            ++this.ticksSinceNotEnoughAir;
            if (this.ticksSinceNotEnoughAir > 20) {
                this.ticksSinceNotEnoughAir = -1;
            }
        }
    }

    private void handleItems(LogisticsModule providingModule, LogisticsModule requestingModule, LogisticsManager.LogisticsTask task) {
        IOHelper.getInventoryForTE(task.requester.getCachedTileEntity(), requestingModule.dir.m_122424_()).ifPresent(requestingHandler -> {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)task.transportingItem, (boolean)true);
            if (remainder.m_41613_() != task.transportingItem.m_41613_()) {
                ItemStack toBeExtracted = task.transportingItem.m_41777_();
                toBeExtracted.m_41774_(remainder.m_41613_());
                IOHelper.getInventoryForTE(task.provider.getCachedTileEntity(), providingModule.dir.m_122424_()).ifPresent(providingHandler -> this.tryItemTransfer(providingModule, requestingModule, (IItemHandler)providingHandler, (IItemHandler)requestingHandler, toBeExtracted));
            }
        });
    }

    private void tryItemTransfer(LogisticsModule providingModule, LogisticsModule requestingModule, IItemHandler providingHandler, IItemHandler requestingHandler, ItemStack toTransfer) {
        ItemStack extractedStack = IOHelper.extract(providingHandler, toTransfer, IOHelper.ExtractCount.UP_TO, true, requestingModule.getFrame().isMatchNBT());
        if (extractedStack.m_41619_()) {
            return;
        }
        requestingModule.getTube().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(receiverAirHandler -> {
            int airUsed = (int)((Double)ConfigHelper.common().logistics.itemTransportCost.get() * (double)extractedStack.m_41613_() * PneumaticCraftUtils.distBetween((Vec3i)providingModule.getTube().m_58899_(), (Vec3i)requestingModule.getTube().m_58899_()));
            if (airUsed > receiverAirHandler.getAir()) {
                double scaleBack = (double)receiverAirHandler.getAir() / (double)airUsed;
                extractedStack.m_41764_((int)((double)extractedStack.m_41613_() * scaleBack));
                airUsed = (int)((double)airUsed * scaleBack);
            }
            if (extractedStack.m_41619_()) {
                this.sendModuleUpdate(providingModule, false);
                this.sendModuleUpdate(requestingModule, false);
            } else {
                this.sendModuleUpdate(providingModule, true);
                this.sendModuleUpdate(requestingModule, true);
                receiverAirHandler.addAir(-airUsed);
                IOHelper.extract(providingHandler, extractedStack, IOHelper.ExtractCount.EXACT, false, requestingModule.getFrame().isMatchNBT());
                ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)extractedStack, (boolean)false);
                this.ticksUntilNextCycle = 20;
            }
        });
    }

    private void handleFluids(LogisticsModule providingModule, LogisticsModule requestingModule, LogisticsManager.LogisticsTask task) {
        task.requester.getCachedTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, requestingModule.dir.m_122424_()).ifPresent(requestingHandler -> {
            int amountFilled = requestingHandler.fill(task.transportingFluid, IFluidHandler.FluidAction.SIMULATE);
            if (amountFilled > 0) {
                FluidStack drainingFluid = task.transportingFluid.copy();
                drainingFluid.setAmount(amountFilled);
                task.provider.getCachedTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, providingModule.dir.m_122424_()).ifPresent(providingHandler -> this.tryFluidTransfer(providingModule, (IFluidHandler)providingHandler, requestingModule, (IFluidHandler)requestingHandler, drainingFluid));
            }
        });
    }

    private void tryFluidTransfer(LogisticsModule providingModule, IFluidHandler providingHandler, LogisticsModule requestingModule, IFluidHandler requestingHandler, FluidStack toTransfer) {
        FluidStack extractedFluid = providingHandler.drain(toTransfer, IFluidHandler.FluidAction.SIMULATE);
        if (extractedFluid.isEmpty()) {
            return;
        }
        requestingModule.getTube().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(receiverAirHandler -> {
            double airUsed = (Double)ConfigHelper.common().logistics.fluidTransportCost.get() * (double)extractedFluid.getAmount() * PneumaticCraftUtils.distBetween((Vec3i)providingModule.getTube().m_58899_(), (Vec3i)requestingModule.getTube().m_58899_());
            if (airUsed > (double)receiverAirHandler.getAir()) {
                double scaleBack = (double)receiverAirHandler.getAir() / airUsed;
                toTransfer.setAmount((int)((double)extractedFluid.getAmount() * scaleBack));
                airUsed *= scaleBack;
            }
            if (toTransfer.isEmpty()) {
                this.sendModuleUpdate(providingModule, false);
                this.sendModuleUpdate(requestingModule, false);
            } else {
                this.sendModuleUpdate(providingModule, true);
                this.sendModuleUpdate(requestingModule, true);
                receiverAirHandler.addAir((int)(-airUsed));
                requestingHandler.fill(providingHandler.drain(toTransfer, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.ticksUntilNextCycle = 20;
            }
        });
    }

    private void sendModuleUpdate(LogisticsModule module, boolean enoughAir) {
        NetworkHandler.sendToAllTracking((Object)new PacketUpdateLogisticsModule(module, enoughAir ? 1 : 2), module.getTube());
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        String status = this.ticksSinceAction >= 0 ? "pneumaticcraft.waila.logisticsModule.transporting" : (this.ticksSinceNotEnoughAir >= 0 ? "pneumaticcraft.waila.logisticsModule.notEnoughAir" : (this.hasPower() ? "pneumaticcraft.waila.logisticsModule.powered" : "pneumaticcraft.waila.logisticsModule.noPower"));
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.hud.msg.state", new Object[0]).m_130946_(": ").m_7220_((Component)PneumaticCraftUtils.xlate(status, new Object[0])));
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }
}

