/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.immersiveengineering;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.immersiveengineering.ElectricAttackHandler;
import me.desht.pneumaticcraft.common.thirdparty.immersiveengineering.IEHeatHandler;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ImmersiveEngineering
implements IThirdParty {
    private static final ResourceLocation HEMP_BLOCK = new ResourceLocation("immersiveengineering:hemp");

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register(ElectricAttackHandler.class);
        MinecraftForge.EVENT_BUS.register(ExternalHeatCapListener.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(HarvestListener.class);
    }

    public static class ExternalHeatCapListener {
        @SubscribeEvent
        public static void attachExternalHeatHandler(AttachCapabilitiesEvent<BlockEntity> event) {
            if (event.getObject() instanceof IHeatExchangingTE) {
                IEHeatHandler.Provider provider = new IEHeatHandler.Provider((BlockEntity)event.getObject());
                event.addCapability(PneumaticRegistry.RL("ie_external_heatable"), (ICapabilityProvider)provider);
                event.addListener(provider::invalidate);
            }
        }
    }

    public static class HarvestListener {
        @SubscribeEvent
        public static void registerHarvestHandler(RegistryEvent.Register<HarvestHandler> event) {
            Block hempBlock = (Block)ForgeRegistries.BLOCKS.getValue(HEMP_BLOCK);
            if (hempBlock != null && hempBlock != Blocks.f_50016_) {
                event.getRegistry().register((IForgeRegistryEntry)((HarvestHandler)new HarvestHandlerCactusLike(state -> state.m_60734_() == hempBlock).setRegistryName(PneumaticRegistry.RL("ie_hemp"))));
            } else {
                Log.error("block 'immersiveengineering:hemp' did not get registered? PneumaticCraft drone harvesting won't work!", new Object[0]);
            }
        }
    }
}

