/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IProgWidgetBase;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public interface IProgWidget
extends IProgWidgetBase {
    public int getX();

    public int getY();

    public void setX(int var1);

    public void setY(int var1);

    public int getWidth();

    public int getHeight();

    public ResourceLocation getTexture();

    public Pair<Float, Float> getMaxUV();

    public void getTooltip(List<Component> var1);

    public void addWarnings(List<Component> var1, List<IProgWidget> var2);

    public void addErrors(List<Component> var1, List<IProgWidget> var2);

    public boolean hasStepInput();

    public boolean hasStepOutput();

    default public boolean freeToUse() {
        return false;
    }

    public Goal getWidgetAI(IDroneBase var1, IProgWidget var2);

    public Goal getWidgetTargetAI(IDroneBase var1, IProgWidget var2);

    public void setOutputWidget(IProgWidget var1);

    public IProgWidget getOutputWidget();

    public IProgWidget getOutputWidget(IDroneBase var1, List<IProgWidget> var2);

    public ProgWidgetType<?> returnType();

    @Nonnull
    public List<ProgWidgetType<?>> getParameters();

    public void setParameter(int var1, IProgWidget var2);

    public boolean canSetParameter(int var1);

    public IProgWidget[] getConnectedParameters();

    public void setParent(IProgWidget var1);

    public IProgWidget getParent();

    public ResourceLocation getTypeID();

    default public String getTranslationKey() {
        String s = this.getTypeID().toString().replace(':', '.');
        return "programmingPuzzle." + s + ".name";
    }

    public DyeColor getColor();

    public boolean isAvailable();

    public void writeToNBT(CompoundTag var1);

    public void readFromNBT(CompoundTag var1);

    public IProgWidget copy();

    public boolean canBeRunByComputers(IDroneBase var1, IProgWidget var2);

    default public boolean isDifficultyOK(WidgetDifficulty difficulty) {
        return this.getDifficulty().isNotMoreDifficult(difficulty);
    }

    public WidgetDifficulty getDifficulty();

    public ProgWidgetType<?> getType();

    public void readFromPacket(FriendlyByteBuf var1);

    public void writeToPacket(FriendlyByteBuf var1);

    @Nonnull
    public List<Component> getExtraStringInfo();

    public static IProgWidget create(ProgWidgetType<?> type) {
        Object base = type.create();
        Validate.isTrue((boolean)(base instanceof IProgWidget));
        return (IProgWidget)base;
    }

    public static enum WidgetDifficulty {
        EASY("easy", 0),
        MEDIUM("medium", 1),
        ADVANCED("advanced", 2);

        private final String name;
        private final int difficultyLevel;

        private WidgetDifficulty(String name, int difficultyLevel) {
            this.name = name;
            this.difficultyLevel = difficultyLevel;
        }

        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.difficulty." + this.name;
        }

        public String getTooltipTranslationKey() {
            return "pneumaticcraft.gui.programmer.difficulty." + this.name + ".tooltip";
        }

        public boolean isNotMoreDifficult(WidgetDifficulty other) {
            return this.difficultyLevel <= other.difficultyLevel;
        }
    }
}

