/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EnderVisorClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.item.CompressedIronArmorMaterial;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ElytraHandler;
import me.desht.pneumaticcraft.common.recipes.special.OneProbeCrafting;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class PneumaticArmorItem
extends ArmorItem
implements IChargeableContainerProvider,
IFOVModifierItem,
ICustomDurabilityBar,
IPressurizableItem,
DyeableLeatherItem,
ColorHandlers.ITintableItem {
    private static final UUID[] PNEUMATIC_ARMOR_MODIFIERS = new UUID[]{UUID.fromString("4a6bf01d-2e83-4b13-aaf0-a4c05958ea3c"), UUID.fromString("ad78a169-0409-47fb-8ca2-126b19196b56"), UUID.fromString("87bf456d-7360-407d-8592-5a2583eb948c"), UUID.fromString("e836e6c9-355e-49f2-87fc-331fadfdd642")};
    private static final ArmorMaterial PNEUMATIC_ARMOR_MATERIAL = new CompressedIronArmorMaterial(0.2f);
    private static final int[] ARMOR_VOLUMES = new int[]{12000, 12000, 28000, 12000};
    public static final String NBT_SEARCH_ITEM = "SearchStack";
    public static final String NBT_COORD_TRACKER = "CoordTracker";
    public static final String NBT_ENTITY_FILTER = "entityFilter";
    public static final String NBT_JUMP_BOOST = "jumpBoost";
    public static final String NBT_SPEED_BOOST = "speedBoost";
    public static final String NBT_BUILDER_MODE = "JetBootsBuilderMode";
    public static final String NBT_JET_BOOTS_POWER = "JetBootsPower";
    public static final String NBT_FLIGHT_STABILIZERS = "JetBootsStabilizers";
    public static final String NBT_SMART_HOVER = "SmartHover";
    public static final int DEFAULT_PRIMARY_COLOR = -6908266;
    public static final int DEFAULT_SECONDARY_COLOR = -4144960;
    public static final int DEFAULT_EYEPIECE_COLOR = -16733696;

    public PneumaticArmorItem(EquipmentSlot equipmentSlotIn) {
        super(PNEUMATIC_ARMOR_MATERIAL, equipmentSlotIn, ModItems.defaultProps());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new AirHandlerItemStack(stack, 10.0f);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new EnderVisorClientHandler.PumpkinOverlay());
    }

    public static boolean isPlayerWearingAnyPneumaticArmor(Player player) {
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            if (!PneumaticArmorItem.isPneumaticArmorPiece(player, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPneumaticArmorPiece(Player player, EquipmentSlot slot) {
        return player.m_6844_(slot).m_41720_() instanceof PneumaticArmorItem;
    }

    @Override
    public int getBaseVolume() {
        return ARMOR_VOLUMES[this.f_40377_.m_20749_()];
    }

    @Override
    public int getVolumeUpgrades(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, (PNCUpgrade)((Object)ModUpgrades.VOLUME.get()));
    }

    @Override
    public int getAir(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("pneumaticcraft:air") : 0;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String s = slot == EquipmentSlot.LEGS ? "pneumaticcraft:textures/armor/pneumatic_2" : "pneumaticcraft:textures/armor/pneumatic_1";
        return type == null ? s + ".png" : s + "_" + type + ".png";
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.f_40377_ == EquipmentSlot.HEAD && worldIn != null) {
            this.addHelmetInformation(stack, worldIn, tooltip);
        }
    }

    private void addHelmetInformation(ItemStack stack, Level worldIn, List<Component> tooltip) {
        BlockPos pos;
        ItemStack searchStack;
        Item searchedItem;
        if (OneProbeCrafting.isOneProbeEnabled(stack)) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("gui.tooltip.item.pneumaticcraft.pneumatic_helmet.one_probe", new Object[0]).m_130940_(ChatFormatting.BLUE));
        }
        if ((searchedItem = PneumaticArmorItem.getSearchedItem(stack)) != null && !(searchStack = new ItemStack((ItemLike)searchedItem)).m_41619_()) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.search", new Object[0]).m_130946_(": ").m_7220_(searchStack.m_41786_()).m_130940_(ChatFormatting.YELLOW));
        }
        if ((pos = PneumaticArmorItem.getCoordTrackerPos(stack, worldIn)) != null) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.coordinate_tracker", new Object[0]).m_130946_(": ").m_130946_(PneumaticCraftUtils.posToString(pos)).m_130940_(ChatFormatting.YELLOW));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return (Boolean)ConfigHelper.client().armor.showEnchantGlint.get() != false && super.m_5812_(stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create((Multimap)super.getAttributeModifiers(equipmentSlot, stack));
        if (equipmentSlot == this.f_40377_) {
            int upgrades = UpgradableItemUtils.getUpgradeCount(stack, (PNCUpgrade)((Object)ModUpgrades.ARMOR.get()));
            multimap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(PNEUMATIC_ARMOR_MODIFIERS[equipmentSlot.m_20749_()], "Pneumatic Armor modifier boost", (double)upgrades / 2.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(PNEUMATIC_ARMOR_MODIFIERS[equipmentSlot.m_20749_()], "Pneumatic Armor toughness boost", (double)upgrades, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return (Boolean)ConfigHelper.common().advanced.nbtToClientModification.get() != false ? PressurizableItem.roundedPressure(stack) : super.getShareTag(stack);
    }

    public static int getIntData(ItemStack stack, String key, int def) {
        if (stack.m_41720_() instanceof PneumaticArmorItem && stack.m_41782_() && stack.m_41783_().m_128425_(key, 3)) {
            return stack.m_41783_().m_128451_(key);
        }
        return def;
    }

    public static int getIntData(ItemStack stack, String key, int def, int min, int max) {
        if (stack.m_41720_() instanceof PneumaticArmorItem && stack.m_41782_() && stack.m_41783_().m_128425_(key, 3)) {
            return Mth.m_14045_((int)stack.m_41783_().m_128451_(key), (int)min, (int)max);
        }
        return def;
    }

    public static boolean getBooleanData(ItemStack stack, String key, boolean def) {
        if (stack.m_41720_() instanceof PneumaticArmorItem && stack.m_41782_() && stack.m_41783_().m_128425_(key, 1)) {
            return stack.m_41783_().m_128445_(key) == 1;
        }
        return def;
    }

    public static Item getSearchedItem(ItemStack helmetStack) {
        if (helmetStack.m_41619_() || !NBTUtils.hasTag(helmetStack, NBT_SEARCH_ITEM)) {
            return null;
        }
        String itemName = NBTUtils.getString(helmetStack, NBT_SEARCH_ITEM);
        return itemName.isEmpty() ? null : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
    }

    public static void setSearchedItem(ItemStack helmetStack, Item searchedItem) {
        if (helmetStack.m_41720_() instanceof PneumaticArmorItem) {
            NBTUtils.setString(helmetStack, NBT_SEARCH_ITEM, searchedItem.getRegistryName().toString());
        }
    }

    public static BlockPos getCoordTrackerPos(ItemStack helmetStack, Level world) {
        if (helmetStack.m_41619_() || !NBTUtils.hasTag(helmetStack, NBT_COORD_TRACKER)) {
            return null;
        }
        CompoundTag tag = NBTUtils.getCompoundTag(helmetStack, NBT_COORD_TRACKER);
        GlobalPos gPos = GlobalPosHelper.fromNBT(tag);
        if (world.m_151562_(gPos.m_122646_().m_123342_()) || !GlobalPosHelper.isSameWorld(gPos, world)) {
            return null;
        }
        return gPos.m_122646_();
    }

    public static void setCoordTrackerPos(ItemStack helmetStack, GlobalPos gPos) {
        NBTUtils.setCompoundTag(helmetStack, NBT_COORD_TRACKER, (Tag)GlobalPosHelper.toNBT(gPos));
    }

    public static String getEntityFilter(ItemStack helmetStack) {
        if (helmetStack.m_41619_() || !NBTUtils.hasTag(helmetStack, NBT_ENTITY_FILTER)) {
            return "";
        }
        return NBTUtils.getString(helmetStack, NBT_ENTITY_FILTER);
    }

    public static boolean isPlayerDebuggingDrone(Player player, AbstractDroneEntity e) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41720_() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (e instanceof DroneEntity) {
            return NBTUtils.getInteger(helmet, "debuggingDrone") == e.m_142049_();
        }
        if (e instanceof ProgrammableControllerEntity) {
            CompoundTag tag = helmet.m_41737_("debuggingPC");
            return tag != null && NbtUtils.m_129239_((CompoundTag)tag).equals((Object)((ProgrammableControllerEntity)e).getControllerPos());
        }
        return false;
    }

    public static boolean isPlayerDebuggingDrone(Player player, IDroneBase e) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41720_() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (e instanceof DroneEntity) {
            return NBTUtils.getInteger(helmet, "debuggingDrone") == ((DroneEntity)e).m_142049_();
        }
        if (e instanceof ProgrammableControllerBlockEntity) {
            CompoundTag tag = helmet.m_41737_("debuggingPC");
            return tag != null && NbtUtils.m_129239_((CompoundTag)tag).equals((Object)((ProgrammableControllerBlockEntity)e).m_58899_());
        }
        return false;
    }

    public static IDroneBase getDebuggedDrone() {
        ItemStack helmet = ClientUtils.getClientPlayer().m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41720_() == ModItems.PNEUMATIC_HELMET.get() && helmet.m_41782_()) {
            BlockEntity te;
            Entity e;
            int id;
            CompoundTag tag = Objects.requireNonNull(helmet.m_41783_());
            if (tag.m_128441_("debuggingDrone") && (id = tag.m_128451_("debuggingDrone")) > 0 && (e = ClientUtils.getClientLevel().m_6815_(id)) instanceof IDroneBase) {
                return (IDroneBase)e;
            }
            if (tag.m_128441_("debuggingPC") && (te = ClientUtils.getClientLevel().m_7702_(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("debuggingPC")))) instanceof IDroneBase) {
                return (IDroneBase)te;
            }
        }
        return null;
    }

    @Override
    public float getFOVModifier(ItemStack stack, Player player, EquipmentSlot slot) {
        double boost;
        if (slot == EquipmentSlot.LEGS && (Double)ConfigHelper.client().armor.leggingsFOVFactor.get() > 0.0 && (boost = CommonUpgradeHandlers.runSpeedHandler.getSpeedBoostFromLegs(CommonArmorHandler.getHandlerForPlayer())) > 0.0) {
            return 1.0f + (float)(boost * 2.0 * (Double)ConfigHelper.client().armor.leggingsFOVFactor.get());
        }
        return 1.0f;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, (MenuType<? extends ChargingStationUpgradeManagerMenu>)((MenuType)ModMenuTypes.CHARGING_ARMOR.get()));
    }

    @Override
    public boolean shouldShowCustomDurabilityBar(ItemStack stack) {
        return PressurizableItem.shouldShowPressureDurability(stack);
    }

    @Override
    public int getCustomDurabilityColour(ItemStack stack) {
        return PressurizableItem.getPressureDurabilityColor(stack);
    }

    @Override
    public float getCustomDurability(ItemStack stack) {
        return ((Float)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> Float.valueOf(h.getPressure() / h.maxPressure())).orElseThrow(RuntimeException::new)).floatValue();
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return switch (tintIndex) {
            case 0 -> this.m_41121_(stack);
            case 1 -> this.getSecondaryColor(stack);
            case 2 -> {
                if (stack.m_41720_() == ModItems.PNEUMATIC_HELMET.get()) {
                    yield this.getEyepieceColor(stack);
                }
                yield -1;
            }
            default -> -1;
        };
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("display");
        return nbt != null && nbt.m_128425_("color", 99) ? nbt.m_128451_("color") : -6908266;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            Item item = stack.m_41720_();
            if (item instanceof PneumaticArmorItem) {
                PneumaticArmorItem armor = (PneumaticArmorItem)item;
                return CommonArmorHandler.getHandlerForPlayer(player).getUpgradeCount(armor.m_40402_(), (PNCUpgrade)((Object)ModUpgrades.GILDED.get())) > 0;
            }
        }
        return false;
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.upgradeUsable(CommonUpgradeHandlers.enderVisorHandler, true);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            return CommonArmorHandler.getHandlerForPlayer(player).getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)((Object)ModUpgrades.FLIPPERS.get())) > 0;
        }
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, (PNCUpgrade)((Object)ModUpgrades.CREATIVE.get())) == 0;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        Player player;
        return entity instanceof Player && CommonArmorHandler.getHandlerForPlayer(player = (Player)entity).upgradeUsable(CommonUpgradeHandlers.elytraHandler, true);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return ElytraHandler.handleFlightTick(entity, flightTicks);
    }

    public int getSecondaryColor(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("display");
        return nbt != null && nbt.m_128425_("color2", 99) ? nbt.m_128451_("color2") : -4144960;
    }

    public void setSecondaryColor(ItemStack stack, int color) {
        stack.m_41698_("display").m_128405_("color2", color);
    }

    public int getEyepieceColor(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("display");
        return nbt != null && nbt.m_128425_("color_eye", 99) ? nbt.m_128451_("color_eye") : -16733696;
    }

    public void setEyepieceColor(ItemStack stack, int color) {
        stack.m_41698_("display").m_128405_("color_eye", color);
    }
}

