/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class DrillBitItem
extends Item {
    private final DrillBitType type;

    public DrillBitItem(DrillBitType type) {
        super(ModItems.defaultProps().m_41487_(1));
        this.type = type;
    }

    public DrillBitType getType() {
        return this.type;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.tier", new Object[0]).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent(this.getType().tier.toString()).m_130940_(ChatFormatting.GOLD)));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.blocks", new Object[0]).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent(Integer.toString(this.getType().getBestDigType().getBlocksDug())).m_130940_(ChatFormatting.GOLD)));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.speed", new Object[0]).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent(Integer.toString(this.getType().baseEfficiency)).m_130940_(ChatFormatting.GOLD)));
    }

    public static enum DrillBitType {
        NONE("none", (Tier)Tiers.WOOD, 0, 1, 0),
        IRON("iron", (Tier)Tiers.IRON, -2565928, 6, 1),
        COMPRESSED_IRON("compressed_iron", (Tier)Tiers.IRON, -11712442, 7, 2),
        DIAMOND("diamond", (Tier)Tiers.DIAMOND, -11866663, 8, 3),
        NETHERITE("netherite", (Tier)Tiers.NETHERITE, -13555414, 9, 4);

        private final String name;
        private final Tier tier;
        private final int tint;
        private final int baseEfficiency;
        private final int bitQuality;

        private DrillBitType(String name, Tier tier, int tint, int baseEfficiency, int bitQuality) {
            this.name = name;
            this.tier = tier;
            this.tint = tint;
            this.baseEfficiency = baseEfficiency;
            this.bitQuality = bitQuality;
        }

        public Tier getTier() {
            return this.tier;
        }

        public int getTint() {
            return this.tint;
        }

        public int getBitQuality() {
            return this.bitQuality;
        }

        public String getRegistryName() {
            return "drill_bit_" + this.name;
        }

        public int getBaseEfficiency() {
            return this.baseEfficiency;
        }

        public ItemStack asItemStack() {
            return this == NONE ? ItemStack.f_41583_ : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(PneumaticRegistry.RL(this.getRegistryName())));
        }

        public JackHammerItem.DigMode getBestDigType() {
            for (int i = JackHammerItem.DigMode.values().length - 1; i >= 0; --i) {
                JackHammerItem.DigMode digMode = JackHammerItem.DigMode.values()[i];
                if (digMode.getBitType().getBitQuality() > this.getBitQuality()) continue;
                return digMode;
            }
            return JackHammerItem.DigMode.MODE_1X1;
        }
    }
}

