/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatExtractionTracker;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourLiquid;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public abstract class HeatBehaviourTransition
extends HeatBehaviourLiquid {
    private double maxExchangedHeat;
    private double blockTemp = -1.0;
    private LazyOptional<IHeatExchangerLogic> logic;
    private HeatExtractionTracker tracker;

    @Override
    public boolean isApplicable() {
        this.logic = HeatExchangerManager.getInstance().getLogic(this.getWorld(), this.getPos(), null);
        return this.logic.isPresent();
    }

    @Override
    public HeatBehaviour initialize(IHeatExchangerLogic connectedHeatLogic, Level world, BlockPos pos, Direction direction) {
        super.initialize(connectedHeatLogic, world, pos, direction);
        this.tracker = HeatExtractionTracker.getInstance(this.getWorld());
        return this;
    }

    protected abstract int getMaxExchangedHeat();

    protected boolean transformBlockHot() {
        return false;
    }

    protected boolean transformBlockCold() {
        return false;
    }

    @Override
    public void tick() {
        double extractedHeat;
        if (this.blockTemp == -1.0) {
            this.logic.ifPresent(exchanger -> {
                this.blockTemp = exchanger.getTemperature();
                this.maxExchangedHeat = (double)this.getMaxExchangedHeat() * (exchanger.getThermalResistance() + this.getHeatExchanger().getThermalResistance());
            });
        }
        if ((extractedHeat = this.tracker.getHeatExtracted(this.getPos())) < Math.abs(this.maxExchangedHeat)) {
            double toExtract = this.blockTemp - this.getHeatExchanger().getTemperature();
            this.tracker.extractHeat(this.getPos(), toExtract);
            extractedHeat += toExtract;
        }
        if (extractedHeat >= this.maxExchangedHeat) {
            if (this.transformBlockCold()) {
                this.tracker.extractHeat(this.getPos(), -this.maxExchangedHeat);
            }
        } else if (extractedHeat <= -this.maxExchangedHeat && this.transformBlockHot()) {
            this.tracker.extractHeat(this.getPos(), this.maxExchangedHeat);
        }
    }

    void onTransition(BlockPos pos) {
        this.getWorld().m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 2.6f + (this.getWorld().f_46441_.nextFloat() - this.getWorld().f_46441_.nextFloat()) * 0.8f);
        NetworkHandler.sendToAllTracking(new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123762_, pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_(), 0.0, 0.0, 0.0, 8, 1.0, 0.0, 1.0), this.getWorld(), pos);
    }

    public double getExtractionProgress() {
        return this.maxExchangedHeat == 0.0 ? 0.0 : this.tracker.getHeatExtracted(this.getPos()) / this.maxExchangedHeat;
    }
}

