/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.PneumaticCraftBucketItem;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class FluidPlastic {
    private static final FluidAttributes.Builder ATTRS = FluidAttributes.builder((ResourceLocation)PneumaticRegistry.RL("block/fluid/plastic_still"), (ResourceLocation)PneumaticRegistry.RL("block/fluid/plastic_flow")).temperature(423);
    private static final ForgeFlowingFluid.Properties PROPS = new ForgeFlowingFluid.Properties(ModFluids.PLASTIC, ModFluids.PLASTIC_FLOWING, ATTRS).block(ModBlocks.PLASTIC).bucket(ModItems.PLASTIC_BUCKET);

    public static class Bucket
    extends PneumaticCraftBucketItem
    implements ICustomTooltipName {
        public Bucket() {
            super((Supplier<? extends Fluid>)ModFluids.PLASTIC);
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return (Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get() != false ? this.m_5524_() : this.m_5524_() + ".not_in_world";
        }
    }

    public static class Flowing
    extends ForgeFlowingFluid.Flowing {
        public Flowing() {
            super(PROPS);
        }
    }

    public static class Source
    extends ForgeFlowingFluid.Source {
        public Source() {
            super(PROPS);
        }

        public int m_6718_(LevelReader world) {
            return 10;
        }

        public void m_6292_(Level worldIn, BlockPos pos, FluidState state) {
            if (((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue()) {
                ItemEntity item = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.PLASTIC.get()));
                worldIn.m_7967_((Entity)item);
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
            super.m_6292_(worldIn, pos, state);
        }
    }
}

