/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import com.mojang.authlib.GameProfile;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.Validate;

public class TumblingBlockEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<BlockPos> ORIGIN = SynchedEntityData.m_135353_(TumblingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<ItemStack> STATE_STACK = SynchedEntityData.m_135353_(TumblingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static FakePlayer fakePlayer;
    private static final Vec3 Y_POS;
    public final Vector3f tumbleVec;

    public TumblingBlockEntity(EntityType<TumblingBlockEntity> type, Level worldIn) {
        super(type, worldIn);
        this.tumbleVec = this.makeTumbleVec(worldIn, null);
    }

    public TumblingBlockEntity(Level worldIn, LivingEntity thrower, double x, double y, double z, @Nonnull ItemStack stack) {
        super((EntityType)ModEntityTypes.TUMBLING_BLOCK.get(), worldIn);
        Validate.isTrue((!stack.m_41619_() && stack.m_41720_() instanceof BlockItem ? 1 : 0) != 0);
        this.m_5602_((Entity)thrower);
        this.f_19850_ = true;
        this.m_6034_(x, y + (double)((1.0f - this.m_20206_()) / 2.0f), z);
        this.m_20334_(0.0, 0.0, 0.0);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.tumbleVec = this.makeTumbleVec(worldIn, thrower);
        this.setOrigin(this.m_142538_());
        this.f_19804_.m_135381_(STATE_STACK, (Object)stack);
    }

    private Vector3f makeTumbleVec(Level world, LivingEntity thrower) {
        if (thrower != null) {
            return new Vector3f(thrower.m_20154_().m_82537_(Y_POS));
        }
        if (world != null && world.f_46443_) {
            Player player = ClientUtils.getClientPlayer();
            return player == null ? null : new Vector3f(player.m_20154_().m_82537_(Y_POS));
        }
        return null;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ORIGIN, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(STATE_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_37251_(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
    }

    public ItemStack getStack() {
        return (ItemStack)this.f_19804_.m_135370_(STATE_STACK);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.f_19804_.m_135370_(ORIGIN);
    }

    private void setOrigin(BlockPos pos) {
        this.f_19804_.m_135381_(ORIGIN, (Object)pos);
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            BlockPos blockpos1 = this.m_142538_();
            if (!(this.f_19861_ || (this.f_19797_ <= 100 || blockpos1.m_123342_() >= 1 && blockpos1.m_123342_() <= 256) && this.f_19797_ <= 600)) {
                this.dropAsItem();
                this.m_146870_();
            }
        }
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                if (!this.tryPlaceAsBlock((BlockHitResult)result)) {
                    this.dropAsItem();
                }
            } else {
                this.dropAsItem();
            }
        }
    }

    private boolean tryPlaceAsBlock(BlockHitResult brtr) {
        BlockSnapshot snapshot;
        BlockPos pos;
        ItemStack stack = this.getStack();
        if (!(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        BlockPos pos0 = brtr.m_82425_();
        Direction face = brtr.m_82434_();
        Player placer = this.m_37282_() instanceof Player ? (Player)this.m_37282_() : this.getFakePlayer();
        BlockState state = this.f_19853_.m_8055_(pos0);
        LocalBlockPlaceContext ctx = new LocalBlockPlaceContext(new UseOnContext(placer, InteractionHand.MAIN_HAND, brtr));
        BlockPos blockPos = pos = state.m_60629_((BlockPlaceContext)ctx) ? pos0 : pos0.m_142300_(face);
        if (this.f_19853_.m_8055_(pos).m_60629_((BlockPlaceContext)ctx) && !ForgeEventFactory.onBlockPlace((Entity)placer, (BlockSnapshot)(snapshot = BlockSnapshot.create((ResourceKey)this.f_19853_.m_46472_(), (LevelAccessor)this.f_19853_, (BlockPos)pos)), (Direction)face)) {
            InteractionResult res = ((BlockItem)stack.m_41720_()).m_40576_((BlockPlaceContext)ctx);
            return res == InteractionResult.SUCCESS || res == InteractionResult.CONSUME;
        }
        return false;
    }

    private void dropAsItem() {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5552_(this.getStack().m_41777_(), 0.0f);
        }
    }

    private Player getFakePlayer() {
        if (fakePlayer == null) {
            fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.f_19853_), (GameProfile)new GameProfile(null, "[Tumbling Block]"));
        }
        fakePlayer.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, this.getStack());
        return fakePlayer;
    }

    static {
        Y_POS = new Vec3(0.0, 1.0, 0.0);
    }

    private static class LocalBlockPlaceContext
    extends BlockPlaceContext {
        private final ItemStack stack;

        public LocalBlockPlaceContext(UseOnContext context) {
            super(context);
            this.stack = context.m_43722_().m_41777_();
        }

        public ItemStack m_43722_() {
            return this.stack == null ? ItemStack.f_41583_ : this.stack;
        }
    }
}

