/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.debug;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class DroneDebugEntry {
    private final int progWidgetId;
    private final String message;
    private final BlockPos pos;
    private long receivedTime;

    public DroneDebugEntry(String message, int progWidgetId, BlockPos pos) {
        this.message = message;
        this.pos = pos != null ? pos : BlockPos.f_121853_;
        this.progWidgetId = progWidgetId;
    }

    public DroneDebugEntry(FriendlyByteBuf buf) {
        this.message = buf.m_130277_();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.progWidgetId = buf.readInt();
        this.receivedTime = System.currentTimeMillis();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.message);
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.writeInt(this.progWidgetId);
    }

    public String getMessage() {
        return this.message;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getProgWidgetId() {
        return this.progWidgetId;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public boolean hasCoords() {
        return this.pos.m_123341_() != 0 || this.pos.m_123342_() != 0 || this.pos.m_123343_() != 0;
    }
}

