/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityHacking {

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final IHacking impl = new DefaultImpl();
        private final LazyOptional<IHacking> lazy = LazyOptional.of(() -> this.impl);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
            return PNCCapabilities.HACKING_CAPABILITY.orEmpty(cap, this.lazy);
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            if (!this.impl.getCurrentHacks().isEmpty()) {
                ListTag tagList = new ListTag();
                for (IHackableEntity hackableEntity : this.impl.getCurrentHacks()) {
                    if (hackableEntity.getHackableId() == null) continue;
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("id", hackableEntity.getHackableId().toString());
                    tagList.add(tagList.size(), (Tag)tag);
                }
                compound.m_128365_("hackables", (Tag)tagList);
            }
            return compound;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.getCurrentHacks().clear();
            ListTag tagList = nbt.m_128437_("hackables", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                ResourceLocation hackableId = new ResourceLocation(tagList.m_128728_(i).m_128461_("id"));
                IHackableEntity hackable = CommonArmorRegistry.getInstance().getHackableForId(hackableId);
                if (hackable != null) {
                    this.impl.getCurrentHacks().add(hackable);
                    continue;
                }
                Log.warning("hackable \"" + hackableId + "\" not found when constructing from NBT. Was it deleted?", new Object[0]);
            }
        }
    }

    private static class DefaultImpl
    implements IHacking {
        private final List<IHackableEntity> hackables = new ArrayList<IHackableEntity>();

        private DefaultImpl() {
        }

        @Override
        public void tick(Entity entity) {
            this.hackables.removeIf(hackable -> !hackable.afterHackTick(entity));
        }

        @Override
        public void addHackable(IHackableEntity hackable) {
            this.hackables.add(hackable);
        }

        @Override
        public List<IHackableEntity> getCurrentHacks() {
            return this.hackables;
        }
    }
}

