/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.DisplayTableBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DisplayTableBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];
    private static final BooleanProperty NE = BooleanProperty.m_61465_((String)"ne");
    private static final BooleanProperty SE = BooleanProperty.m_61465_((String)"se");
    private static final BooleanProperty SW = BooleanProperty.m_61465_((String)"sw");
    private static final BooleanProperty NW = BooleanProperty.m_61465_((String)"nw");
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public DisplayTableBlock() {
        super(ModBlocks.defaultProps());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NE, SW, SE, NW});
    }

    @Override
    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state == null) {
            return null;
        }
        boolean[] connected = this.getConnections((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), state);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean[] connected = this.getConnections(worldIn, currentPos, stateIn);
        return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
    }

    private VoxelShape getCachedShape(BlockState state) {
        int shapeIdx = ((Boolean)state.m_61143_((Property)NE) != false ? 1 : 0) | ((Boolean)state.m_61143_((Property)SE) != false ? 2 : 0) | ((Boolean)state.m_61143_((Property)SW) != false ? 4 : 0) | ((Boolean)state.m_61143_((Property)NW) != false ? 8 : 0);
        VoxelShape[] shapeCache = this.getShapeCache();
        if (shapeCache[shapeIdx] == null) {
            VoxelShape shape = this.adjustShapeForHeight(TOP);
            for (Leg leg : Leg.values()) {
                if (((Boolean)state.m_61143_((Property)leg.prop)).booleanValue()) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.adjustShapeForHeight(leg.shape));
            }
            shapeCache[shapeIdx] = shape.m_83296_();
        }
        return shapeCache[shapeIdx];
    }

    private VoxelShape adjustShapeForHeight(VoxelShape shape) {
        AABB aabb = shape.m_83215_();
        return Shapes.m_83048_((double)aabb.f_82288_, (double)Math.max(0.0, aabb.f_82289_ - (1.0 - this.getTableHeight())), (double)aabb.f_82290_, (double)aabb.f_82291_, (double)(aabb.f_82292_ - (1.0 - this.getTableHeight())), (double)aabb.f_82293_);
    }

    public double getTableHeight() {
        return 1.0;
    }

    protected VoxelShape[] getShapeCache() {
        return SHAPE_CACHE;
    }

    protected boolean shelfLegs() {
        return false;
    }

    private boolean[] getConnections(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockPos below = pos.m_7495_();
        if (this.shelfLegs() && !world.m_8055_(below).m_60783_((BlockGetter)world, below, Direction.UP)) {
            return new boolean[]{true, true, true, true};
        }
        boolean connE = this.isMatch(world, pos, state, Direction.EAST);
        boolean connW = this.isMatch(world, pos, state, Direction.WEST);
        boolean connS = this.isMatch(world, pos, state, Direction.SOUTH);
        boolean connN = this.isMatch(world, pos, state, Direction.NORTH);
        boolean[] res = new boolean[4];
        res[Leg.SE.ordinal()] = connE || connS;
        res[Leg.NE.ordinal()] = connE || connN;
        res[Leg.SW.ordinal()] = connW || connS;
        res[Leg.NW.ordinal()] = connW || connN;
        return res;
    }

    private boolean isMatch(LevelAccessor world, BlockPos pos, BlockState state, Direction dir) {
        BlockState state2 = world.m_8055_(pos.m_142300_(dir));
        return state2.m_60734_() == this && this.getRotation(state) == this.getRotation(state2);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getCachedShape(state);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        BlockEntity te = world.m_7702_(pos);
        ItemStack heldStack = player.m_21120_(hand);
        if (player.m_6144_() || te instanceof MenuProvider || ModdedWrenchUtils.getInstance().isWrench(heldStack)) {
            return super.m_6227_(state, world, pos, player, hand, brtr);
        }
        if (te instanceof DisplayTableBlockEntity) {
            if (!world.f_46443_) {
                DisplayTableBlockEntity teDT = (DisplayTableBlockEntity)te;
                if (teDT.getPrimaryInventory().getStackInSlot(0).m_41619_()) {
                    ItemStack excess = teDT.getPrimaryInventory().insertItem(0, player.m_21120_(hand), false);
                    if (!player.m_7500_()) {
                        player.m_21008_(hand, excess);
                    }
                } else {
                    ItemStack stack = teDT.getPrimaryInventory().extractItem(0, 64, false);
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + this.getTableHeight() + 0.1, (double)pos.m_123343_() + 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new DisplayTableBlockEntity(pPos, pState);
    }

    private static enum Leg {
        NE(1, -1, NE, Stream.of(Block.m_49796_((double)14.0, (double)11.5, (double)0.0, (double)15.0, (double)12.5, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)3.0), Block.m_49796_((double)13.5, (double)1.0, (double)0.5, (double)15.5, (double)8.0, (double)2.5), Block.m_49796_((double)13.25, (double)7.0, (double)0.25, (double)15.75, (double)13.0, (double)2.75), Block.m_49796_((double)13.0, (double)11.5, (double)1.0, (double)16.0, (double)12.5, (double)2.0), Block.m_49796_((double)14.0, (double)7.5, (double)0.0, (double)15.0, (double)8.5, (double)3.0), Block.m_49796_((double)13.0, (double)7.5, (double)1.0, (double)16.0, (double)8.5, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()),
        SE(1, 1, SE, Stream.of(Block.m_49796_((double)13.0, (double)11.5, (double)14.0, (double)16.0, (double)12.5, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)13.5, (double)1.0, (double)13.5, (double)15.5, (double)8.0, (double)15.5), Block.m_49796_((double)13.25, (double)7.0, (double)13.25, (double)15.75, (double)13.0, (double)15.75), Block.m_49796_((double)14.0, (double)11.5, (double)13.0, (double)15.0, (double)12.5, (double)16.0), Block.m_49796_((double)13.0, (double)7.5, (double)14.0, (double)16.0, (double)8.5, (double)15.0), Block.m_49796_((double)14.0, (double)7.5, (double)13.0, (double)15.0, (double)8.5, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()),
        SW(-1, 1, SW, Stream.of(Block.m_49796_((double)1.0, (double)11.5, (double)13.0, (double)2.0, (double)12.5, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.5, (double)1.0, (double)13.5, (double)2.5, (double)8.0, (double)15.5), Block.m_49796_((double)0.25, (double)7.0, (double)13.25, (double)2.75, (double)13.0, (double)15.75), Block.m_49796_((double)0.0, (double)11.5, (double)14.0, (double)3.0, (double)12.5, (double)15.0), Block.m_49796_((double)1.0, (double)7.5, (double)13.0, (double)2.0, (double)8.5, (double)16.0), Block.m_49796_((double)0.0, (double)7.5, (double)14.0, (double)3.0, (double)8.5, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()),
        NW(-1, -1, NW, Stream.of(Block.m_49796_((double)0.0, (double)11.5, (double)1.0, (double)3.0, (double)12.5, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)3.0), Block.m_49796_((double)0.5, (double)1.0, (double)0.5, (double)2.5, (double)8.0, (double)2.5), Block.m_49796_((double)0.25, (double)7.0, (double)0.25, (double)2.75, (double)13.0, (double)2.75), Block.m_49796_((double)1.0, (double)11.5, (double)0.0, (double)2.0, (double)12.5, (double)3.0), Block.m_49796_((double)0.0, (double)7.5, (double)1.0, (double)3.0, (double)8.5, (double)2.0), Block.m_49796_((double)1.0, (double)7.5, (double)0.0, (double)2.0, (double)8.5, (double)3.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get());

        final int x;
        final int z;
        final BooleanProperty prop;
        final VoxelShape shape;

        private Leg(int x, int z, BooleanProperty prop, VoxelShape shape) {
            this.x = x;
            this.z = z;
            this.prop = prop;
            this.shape = shape;
        }
    }

    public static class Shelf
    extends DisplayTableBlock {
        private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];

        @Override
        public double getTableHeight() {
            return 0.5;
        }

        @Override
        protected VoxelShape[] getShapeCache() {
            return SHAPE_CACHE;
        }

        @Override
        protected boolean shelfLegs() {
            return true;
        }
    }
}

