/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public class BiomeMatcher
implements IPlayerMatcher {
    private final Set<Biome.BiomeCategory> categories;

    public BiomeMatcher(Set<Biome.BiomeCategory> categories) {
        this.categories = ImmutableSet.copyOf(categories);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.categories.size());
        this.categories.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130068_(arg_0));
    }

    @Override
    public JsonElement toJson() {
        JsonArray cats = new JsonArray();
        this.categories.forEach(cat -> cats.add(cat.name()));
        return cats;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.categories.isEmpty()) {
            List<Component> items = this.categories.stream().map(cat -> new TextComponent(cat.m_47645_())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.biomes", new Object[0]), items);
        }
    }

    @Override
    public boolean test(Player playerEntity) {
        return this.categories.isEmpty() || this.categories.contains(((Biome)playerEntity.f_19853_.m_204166_(playerEntity.m_142538_()).m_203334_()).m_47567_());
    }

    public static class Factory
    implements IPlayerMatcher.MatcherFactory<BiomeMatcher> {
        @Override
        public BiomeMatcher fromJson(JsonElement json) {
            EnumSet<Biome.BiomeCategory> categories = EnumSet.noneOf(Biome.BiomeCategory.class);
            json.getAsJsonArray().forEach(element -> {
                Biome.BiomeCategory cat = Biome.BiomeCategory.m_47643_((String)element.getAsString());
                if (cat == null) {
                    throw new JsonSyntaxException("unknown biome category: " + element.getAsString());
                }
                categories.add(cat);
            });
            return new BiomeMatcher(categories);
        }

        @Override
        public BiomeMatcher fromBytes(FriendlyByteBuf buffer) {
            EnumSet<Biome.BiomeCategory> categories = EnumSet.noneOf(Biome.BiomeCategory.class);
            int nCats = buffer.m_130242_();
            for (int i = 0; i < nCats; ++i) {
                categories.add((Biome.BiomeCategory)buffer.m_130066_(Biome.BiomeCategory.class));
            }
            return new BiomeMatcher(categories);
        }
    }
}

