/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneEntityBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAIEntityImport
extends DroneEntityBase<IEntityProvider, Entity> {
    public DroneAIEntityImport(IDroneBase drone, IEntityProvider progWidget) {
        super(drone, progWidget);
    }

    @Override
    protected boolean isEntityValid(Entity entity) {
        if (entity instanceof LivingEntity || entity instanceof AbstractMinecart || entity instanceof Boat) {
            return this.drone.getCarryingEntities().isEmpty();
        }
        if (((Boolean)ConfigHelper.common().drones.dronesCanImportXPOrbs.get()).booleanValue() && entity instanceof ExperienceOrb) {
            return this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> PneumaticCraftUtils.fillTankWithOrb(handler, (ExperienceOrb)entity, IFluidHandler.FluidAction.SIMULATE)).orElse(false);
        }
        return false;
    }

    @Override
    protected boolean doAction() {
        if (((Boolean)ConfigHelper.common().drones.dronesCanImportXPOrbs.get()).booleanValue() && this.targetedEntity instanceof ExperienceOrb) {
            this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                ExperienceOrb orb = (ExperienceOrb)this.targetedEntity;
                ItemStack heldStack = this.drone.getInv().getStackInSlot(0);
                if (!heldStack.m_41619_() && heldStack.m_41768_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)heldStack) > 0) {
                    int toRepair = Math.min((int)((float)orb.f_20770_ * heldStack.getXpRepairRatio()), heldStack.m_41773_());
                    orb.f_20770_ -= toRepair / 2;
                    heldStack.m_41721_(heldStack.m_41773_() - toRepair);
                }
                if (orb.f_20770_ <= 0 || PneumaticCraftUtils.fillTankWithOrb(handler, orb, IFluidHandler.FluidAction.EXECUTE)) {
                    this.targetedEntity.m_146870_();
                }
            });
        } else {
            this.drone.setCarryingEntity(this.targetedEntity);
        }
        return false;
    }
}

