/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.ai.ChunkPositionSorter;
import me.desht.pneumaticcraft.common.ai.DroneClaimManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnIndicatorParticles;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.ThreadedSorter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class DroneAIBlockInteraction<W extends ProgWidgetAreaItemBase>
extends Goal {
    private static final int MAX_LOOKUPS_PER_SEARCH = 30;
    private static final int DRONE_DEBUG_PARTICLE_RANGE_SQ = 1024;
    protected final IDroneBase drone;
    protected final W progWidget;
    private final IBlockOrdered.Ordering order;
    private BlockPos curPos;
    private final List<BlockPos> area;
    final CollisionGetter worldCache;
    private final List<BlockPos> blacklist = new ArrayList<BlockPos>();
    private int curY;
    private int lastSuccessfulY;
    private int minY;
    private int maxY;
    private ThreadedSorter<BlockPos> sorter;
    private boolean aborted;
    private boolean searching;
    private int searchIndex;
    private int totalActions;
    private int maxActions = -1;

    public DroneAIBlockInteraction(IDroneBase drone, W progWidget) {
        this.drone = drone;
        this.m_7021_(EnumSet.allOf(Goal.Flag.class));
        this.progWidget = progWidget;
        this.order = progWidget instanceof IBlockOrdered ? ((IBlockOrdered)progWidget).getOrder() : IBlockOrdered.Ordering.CLOSEST;
        this.area = ((ProgWidgetAreaItemBase)progWidget).getCachedAreaList();
        this.worldCache = ((ProgWidgetAreaItemBase)progWidget).getChunkCache(drone.world());
        AABB extents = ((ProgWidgetAreaItemBase)progWidget).getAreaExtents();
        if (this.area.size() > 0) {
            this.minY = (int)extents.f_82289_;
            this.maxY = (int)extents.f_82292_;
            if (this.order == IBlockOrdered.Ordering.HIGH_TO_LOW) {
                this.curY = this.maxY;
            } else if (this.order == IBlockOrdered.Ordering.LOW_TO_HIGH) {
                this.curY = this.minY;
            }
        }
    }

    public boolean m_8036_() {
        if (this.aborted || this.maxActions >= 0 && this.totalActions >= this.maxActions) {
            return false;
        }
        if (!this.searching) {
            this.searching = true;
            this.lastSuccessfulY = this.curY;
            this.curPos = null;
            this.searchIndex = 0;
            if (this.sorter == null || this.sorter.isDone()) {
                this.sorter = new ThreadedSorter<BlockPos>(this.area, new ChunkPositionSorter(this.drone, this.order));
            }
            return true;
        }
        return false;
    }

    private void updateY() {
        this.searchIndex = 0;
        if (this.order == IBlockOrdered.Ordering.LOW_TO_HIGH) {
            if (++this.curY > this.maxY) {
                this.curY = this.minY;
            }
        } else if (this.order == IBlockOrdered.Ordering.HIGH_TO_LOW && --this.curY < this.minY) {
            this.curY = this.maxY;
        }
    }

    private boolean isYValid(int y) {
        return y < this.drone.world().m_151558_() && y >= this.drone.world().m_141937_() && this.order == IBlockOrdered.Ordering.CLOSEST || y == this.curY;
    }

    public DroneAIBlockInteraction<?> setMaxActions(int maxActions) {
        this.maxActions = maxActions;
        return this;
    }

    protected abstract boolean isValidPosition(BlockPos var1);

    protected abstract boolean doBlockInteraction(BlockPos var1, double var2);

    public boolean m_8045_() {
        block17: {
            double distSq;
            block18: {
                if (this.aborted) {
                    return false;
                }
                if (this.searching) {
                    if (!this.sorter.isDone()) {
                        return true;
                    }
                    boolean firstRun = true;
                    int searchedBlocks = 0;
                    while (this.curPos == null && this.curY != this.lastSuccessfulY && this.order != IBlockOrdered.Ordering.CLOSEST || firstRun) {
                        firstRun = false;
                        ArrayList<BlockPos> inspectedPositions = new ArrayList<BlockPos>();
                        while (!this.shouldAbort() && this.searchIndex < this.area.size()) {
                            BlockPos pos = this.area.get(this.searchIndex);
                            ++this.searchIndex;
                            if (!(!this.isYValid(pos.m_123342_()) || this.blacklist.contains(pos) || this.respectClaims() && DroneClaimManager.getInstance(this.drone.world()).isClaimed(pos))) {
                                if (!this.drone.getDebugger().getDebuggingPlayers().isEmpty()) {
                                    inspectedPositions.add(pos);
                                }
                                if (this.isValidPosition(pos)) {
                                    this.curPos = pos;
                                    if (this.moveToPositions()) {
                                        if (this.tryMoveToBlock(pos)) {
                                            return true;
                                        }
                                        if (this.drone.getPathNavigator().isGoingToTeleport()) {
                                            return this.movedToBlockOK(pos);
                                        }
                                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.cantNavigate", pos);
                                    } else {
                                        this.searching = false;
                                        ++this.totalActions;
                                        return true;
                                    }
                                }
                                ++searchedBlocks;
                            }
                            if (searchedBlocks < 30) continue;
                            this.indicateToListeningPlayers(inspectedPositions);
                            return true;
                        }
                        this.indicateToListeningPlayers(inspectedPositions);
                        if (this.curPos != null) continue;
                        this.updateY();
                    }
                    if (!this.shouldAbort()) {
                        this.addEndingDebugEntry();
                    }
                    return false;
                }
                if (this.curPos == null) break block17;
                if (this.respectClaims()) {
                    DroneClaimManager.getInstance(this.drone.world()).claim(this.curPos);
                }
                distSq = this.drone.getDronePos().m_82557_(Vec3.m_82512_((Vec3i)this.curPos));
                if (!this.moveToPositions()) break block18;
                int n = this.moveIntoBlock() ? 1 : 4;
                if (!(distSq < (double)n)) break block17;
            }
            return this.doBlockInteraction(this.curPos, distSq);
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    private boolean tryMoveToBlock(BlockPos pos) {
        if (this.moveIntoBlock()) {
            if (this.blockAllowsMovement(this.worldCache, this.curPos, this.worldCache.m_8055_(pos)) && this.drone.getPathNavigator().moveToXYZ(this.curPos.m_123341_(), (double)this.curPos.m_123342_() + 0.5, this.curPos.m_123343_())) {
                return this.movedToBlockOK(pos);
            }
        } else {
            ISidedWidget w = this.progWidget instanceof ISidedWidget ? (ISidedWidget)this.progWidget : null;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockPos pos2 = this.curPos.m_142300_(dir);
                if (this.drone.getDronePos().m_82531_((double)pos2.m_123341_() + 0.5, (double)pos2.m_123342_() + 0.5, (double)pos2.m_123343_() + 0.5) < 0.5) {
                    return this.movedToBlockOK(pos);
                }
                if (w != null && !w.isSideSelected(dir) || !this.blockAllowsMovement(this.worldCache, pos2, this.worldCache.m_8055_(pos2)) || !this.drone.getPathNavigator().moveToXYZ(pos2.m_123341_(), (double)pos2.m_123342_() + 0.5, pos2.m_123343_())) continue;
                return this.movedToBlockOK(pos);
            }
        }
        return false;
    }

    private boolean blockAllowsMovement(CollisionGetter world, BlockPos pos, BlockState state) {
        return state.m_60734_() instanceof LiquidBlock ? this.drone.canMoveIntoFluid((Fluid)((LiquidBlock)state.m_60734_()).getFluid()) : world.m_8055_(pos).m_60647_((BlockGetter)world, pos, PathComputationType.AIR);
    }

    private boolean movedToBlockOK(BlockPos pos) {
        this.searching = false;
        ++this.totalActions;
        if (this.respectClaims()) {
            DroneClaimManager.getInstance(this.drone.world()).claim(pos);
        }
        this.blacklist.clear();
        return true;
    }

    protected void addEndingDebugEntry() {
        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.blockInteraction.debug.noBlocksValid");
    }

    protected boolean respectClaims() {
        return false;
    }

    protected boolean moveIntoBlock() {
        return false;
    }

    private boolean shouldAbort() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean moveToPositions() {
        return true;
    }

    private void indicateToListeningPlayers(List<BlockPos> pos) {
        if (!pos.isEmpty()) {
            for (ServerPlayer player : this.drone.getDebugger().getDebuggingPlayers()) {
                CommonArmorHandler handler;
                if (!(player.m_20275_((double)pos.get(0).m_123341_(), (double)pos.get(0).m_123342_(), (double)pos.get(0).m_123343_()) < 1024.0) || !(handler = CommonArmorHandler.getHandlerForPlayer((Player)player)).upgradeUsable(CommonUpgradeHandlers.entityTrackerHandler, true) || handler.getUpgradeCount(EquipmentSlot.HEAD, (PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) <= 0) continue;
                NetworkHandler.sendToPlayer(new PacketSpawnIndicatorParticles(pos, this.progWidget.getColor()), player);
            }
        }
    }

    void addToBlacklist(BlockPos coord) {
        this.blacklist.add(coord);
        this.drone.sendWireframeToClient(coord);
    }
}

