/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ClientUtils {
    public static void emitParticles(Level world, BlockPos pos, ParticleOptions particle, double yOffset) {
        float xOff = world.f_46441_.nextFloat() * 0.6f + 0.2f;
        float zOff = world.f_46441_.nextFloat() * 0.6f + 0.2f;
        ClientUtils.getClientLevel().m_7106_(particle, (double)((float)pos.m_123341_() + xOff), (double)pos.m_123342_() + yOffset, (double)((float)pos.m_123343_() + zOff), 0.0, 0.0, 0.0);
    }

    public static void emitParticles(Level world, BlockPos pos, ParticleOptions particle) {
        ClientUtils.emitParticles(world, pos, particle, 1.2);
    }

    @Nonnull
    public static ItemStack getWornArmor(EquipmentSlot slot) {
        return ClientUtils.getClientPlayer().m_6844_(slot);
    }

    public static void addDroneToHudHandler(DroneEntity drone, BlockPos pos) {
        ArmorUpgradeClientRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).getTargetsStream().filter(target -> target.entity == drone).forEach(target -> target.getDroneAIRenderer(drone).addBlackListEntry(drone.f_19853_, pos));
    }

    public static boolean isKeyDown(int keyCode) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keyCode);
    }

    public static void openContainerGui(MenuType<? extends AbstractContainerMenu> type, Component displayString) {
        MenuScreens.m_96201_(type, (Minecraft)Minecraft.m_91087_(), (int)-1, (Component)displayString);
    }

    public static void closeContainerGui(Screen parentScreen) {
        Minecraft.m_91087_().m_91152_(parentScreen);
        if (parentScreen instanceof AbstractContainerScreen) {
            ClientUtils.getClientPlayer().f_36096_ = ((AbstractContainerScreen)parentScreen).m_6262_();
        } else if (parentScreen instanceof AbstractProgWidgetScreen) {
            ClientUtils.getClientPlayer().f_36096_ = ((AbstractProgWidgetScreen)parentScreen).getProgrammerContainer();
        }
    }

    @Nonnull
    public static Level getClientLevel() {
        return (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
    }

    public static Optional<Level> getOptionalClientLevel() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91073_);
    }

    @Nonnull
    public static Player getClientPlayer() {
        return (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
    }

    public static boolean hasShiftDown() {
        return Screen.m_96638_();
    }

    public static BlockEntity getBlockEntity(BlockPos pos) {
        return ClientUtils.getClientLevel().m_7702_(pos);
    }

    public static boolean intersects(Rect2i rect, double x, double y, double w, double h) {
        if (rect.m_110090_() <= 0 || rect.m_110091_() <= 0 || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = rect.m_110085_();
        double y0 = rect.m_110086_();
        return x + w > x0 && y + h > y0 && x < x0 + (double)rect.m_110090_() && y < y0 + (double)rect.m_110091_();
    }

    public static boolean isScreenHiRes() {
        Window mw = Minecraft.m_91087_().m_91268_();
        return mw.m_85445_() > 700 && mw.m_85446_() > 512;
    }

    public static float getBrightnessAtWorldHeight() {
        Player player = ClientUtils.getClientPlayer();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(player.m_20185_(), (double)ClientUtils.getClientLevel().m_151558_(), player.m_20189_());
        if (player.f_19853_.m_46749_((BlockPos)pos)) {
            return player.f_19853_.m_6042_().m_63902_(player.f_19853_.m_46803_((BlockPos)pos));
        }
        return 0.0f;
    }

    public static int getLightAt(BlockPos pos) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)ClientUtils.getClientLevel(), (BlockPos)pos);
    }

    public static int getStringWidth(String line) {
        return Minecraft.m_91087_().f_91062_.m_92895_(line);
    }

    public static boolean isGuiOpen(BlockEntity te) {
        if (Minecraft.m_91087_().f_91080_ instanceof AbstractPneumaticCraftContainerScreen) {
            return ((AbstractPneumaticCraftContainerScreen)Minecraft.m_91087_().f_91080_).te == te;
        }
        return false;
    }

    public static float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        List quads = model.getQuads(state, face, ClientUtils.getClientLevel().f_46441_, (IModelData)EmptyModelData.INSTANCE);
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).m_173410_();
            return new float[]{sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_()};
        }
        return null;
    }

    public static void spawnEntityClientside(Entity e) {
        ((ClientLevel)ClientUtils.getClientLevel()).m_104627_(e.m_142049_(), e);
    }

    public static String translateDirection(Direction d) {
        return I18n.m_118938_((String)("pneumaticcraft.gui.tooltip.direction." + d.toString()), (Object[])new Object[0]);
    }

    public static Component translateDirectionComponent(Direction d) {
        return new TranslatableComponent("pneumaticcraft.gui.tooltip.direction." + d.toString());
    }

    public static Component translateKeyBind(KeyMapping keyBinding) {
        return keyBinding.getKeyModifier().getCombinedName(keyBinding.getKey(), () -> {
            Component s = keyBinding.getKey().m_84875_();
            if (keyBinding.getKey().m_84868_() == InputConstants.Type.KEYSYM && keyBinding.getKey().m_84873_() >= 320 && keyBinding.getKey().m_84873_() <= 336) {
                return new TextComponent("KP_").m_7220_(s);
            }
            return s;
        }).m_6881_().m_130940_(ChatFormatting.YELLOW);
    }

    public static void addGuiContextSensitiveTooltip(ItemStack stack, List<Component> tooltip) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen != null) {
            String subKey = screen.getClass().getSimpleName().toLowerCase(Locale.ROOT);
            Item item = stack.m_41720_();
            String base = item instanceof BlockItem ? "gui.tooltip.block" : "gui.tooltip.item";
            String k = String.join((CharSequence)".", base, item.getRegistryName().m_135827_(), item.getRegistryName().m_135815_(), subKey);
            if (I18n.m_118936_((String)k)) {
                tooltip.addAll(GuiUtils.xlateAndSplit(k, new Object[0]).stream().map(s -> s.m_6881_().m_130940_(ChatFormatting.GRAY)).toList());
            }
        }
    }

    public static int getRenderDistanceThresholdSq() {
        int d = Minecraft.m_91087_().f_91066_.f_92106_ * 16;
        return d * d;
    }

    public static boolean isFirstPersonCamera() {
        return Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
    }

    public static float calculateViewScaling(Vec3 targetPos) {
        Player player = ClientUtils.getClientPlayer();
        Vec3 vec1 = targetPos.m_82546_(player.m_20182_());
        double angle = player.m_20154_().m_82526_(vec1.m_82541_());
        float size = 1.0f;
        if (angle >= 0.8) {
            double dist = Math.max(1.0E-4, Math.sqrt(player.m_20238_(targetPos)));
            double s = 0.8 - 1.0 / dist;
            size *= (float)((angle - s) * dist);
        }
        return size;
    }

    public static float getStatSizeMultiplier(double dist) {
        if (dist < 4.0) {
            return Math.max(0.3f, (float)(dist / 4.0));
        }
        if (dist < 10.0) {
            return 1.0f;
        }
        return (float)(dist / 10.0);
    }

    public static void syncViaOpenContainerScreen(int syncId, Object value) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            AbstractContainerMenu container = screen2.m_6262_();
            if (container instanceof AbstractPneumaticCraftMenu) {
                AbstractPneumaticCraftMenu pncMenu = (AbstractPneumaticCraftMenu)container;
                pncMenu.updateField(syncId, value);
            }
            if (screen2 instanceof AbstractPneumaticCraftContainerScreen) {
                AbstractPneumaticCraftContainerScreen pncScreen = (AbstractPneumaticCraftContainerScreen)screen2;
                pncScreen.onGuiUpdate();
            }
        }
    }
}

