/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.sound.MovingSoundAirLeak;
import me.desht.pneumaticcraft.client.sound.MovingSoundElevator;
import me.desht.pneumaticcraft.client.sound.MovingSoundJackhammer;
import me.desht.pneumaticcraft.client.sound.MovingSoundJetBoots;
import me.desht.pneumaticcraft.client.sound.MovingSoundMinigun;
import me.desht.pneumaticcraft.common.block.entity.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class MovingSounds {
    private static final Map<BlockPos, AbstractTickableSoundInstance> posToTickableSound = new HashMap<BlockPos, AbstractTickableSoundInstance>();

    private static AbstractTickableSoundInstance createMovingSound(Sound s, Object focus, Object ... extraData) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return null;
        }
        switch (s) {
            case JET_BOOTS: {
                if (!(focus instanceof Player)) break;
                Player player = (Player)focus;
                return new MovingSoundJetBoots(player);
            }
            case MINIGUN: {
                if (focus instanceof Player || focus instanceof DroneEntity) {
                    return new MovingSoundMinigun((Entity)focus);
                }
                if (!(focus instanceof BlockPos)) break;
                BlockPos pos = (BlockPos)focus;
                BlockEntity te = world.m_7702_(pos);
                return te == null ? null : new MovingSoundMinigun(te);
            }
            case ELEVATOR: {
                if (!(focus instanceof BlockPos)) break;
                BlockPos pos = (BlockPos)focus;
                BlockEntity te = world.m_7702_(pos);
                return te instanceof ElevatorBaseBlockEntity ? new MovingSoundElevator((ElevatorBaseBlockEntity)te) : null;
            }
            case AIR_LEAK: {
                if (!(focus instanceof BlockPos)) break;
                BlockPos pos = (BlockPos)focus;
                AbstractTickableSoundInstance sound = posToTickableSound.get(pos);
                if (sound != null && !sound.m_7801_()) {
                    return null;
                }
                BlockEntity te = world.m_7702_(pos);
                if (te != null && te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).isPresent()) {
                    sound = new MovingSoundAirLeak(te, (Direction)extraData[0]);
                    posToTickableSound.put(pos, sound);
                    return sound;
                }
                return null;
            }
            case JACKHAMMER: {
                if (!(focus instanceof Player)) break;
                Player player = (Player)focus;
                return MovingSoundJackhammer.startOrContinue(player);
            }
        }
        throw new IllegalArgumentException("Invalid moving sound " + s + " for focus object " + focus);
    }

    public static void playMovingSound(Sound s, Object focus, Object ... extraData) {
        AbstractTickableSoundInstance movingSound = MovingSounds.createMovingSound(s, focus, extraData);
        if (movingSound != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)movingSound);
        }
    }

    public static enum Sound {
        JET_BOOTS,
        MINIGUN,
        ELEVATOR,
        AIR_LEAK,
        JACKHAMMER;

    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static class Listener {
        private Listener() {
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
            if (event.getWorld().f_46443_ && event.getEntity() instanceof LocalPlayer) {
                posToTickableSound.clear();
            }
        }

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            posToTickableSound.values().removeIf(AbstractTickableSoundInstance::m_7801_);
        }
    }
}

