/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.fluids.IFluidTank;

public class FluidItemModel
implements IDynamicBakedModel {
    private final BakedModel bakedBaseModel;
    private final ImmutableMap<ItemTransforms.TransformType, Transformation> transformMap;
    private final ItemOverrides overrideList = new FluidOverridesList(this);
    private List<TankRenderInfo> tanksToRender = Collections.emptyList();

    private FluidItemModel(BakedModel bakedBaseModel, ImmutableMap<ItemTransforms.TransformType, Transformation> transformMap) {
        this.bakedBaseModel = bakedBaseModel;
        this.transformMap = transformMap;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> res = new ArrayList<BakedQuad>(this.bakedBaseModel.getQuads(state, side, rand, extraData));
        for (TankRenderInfo info : this.tanksToRender) {
            ImmutableList vecs;
            IFluidTank tank = info.getTank();
            if (tank.getFluid().isEmpty()) continue;
            Fluid fluid = tank.getFluid().getFluid();
            ResourceLocation texture = fluid.getAttributes().getStillTexture(tank.getFluid());
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
            int color = fluid.getAttributes().getColor(tank.getFluid());
            float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            AABB bounds = this.getRenderBounds(tank, info.getBounds());
            float bx1 = (float)(bounds.f_82288_ * 16.0);
            float bx2 = (float)(bounds.f_82291_ * 16.0);
            float by1 = (float)(bounds.f_82289_ * 16.0);
            float by2 = (float)(bounds.f_82292_ * 16.0);
            float bz1 = (float)(bounds.f_82290_ * 16.0);
            float bz2 = (float)(bounds.f_82293_ * 16.0);
            if (info.shouldRender(Direction.DOWN)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.DOWN, bx1, bx2, bz1, bz2));
            }
            if (info.shouldRender(Direction.UP)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.UP, bx1, bx2, bz1, bz2));
            }
            if (info.shouldRender(Direction.NORTH)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.NORTH, bx1, bx2, by1, by2));
            }
            if (info.shouldRender(Direction.SOUTH)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
            }
            if (info.shouldRender(Direction.WEST)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.WEST, bz1, bz2, by1, by2));
            }
            if (!info.shouldRender(Direction.EAST)) continue;
            vecs = ImmutableList.of((Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_));
            res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.EAST, bz1, bz2, by1, by2));
        }
        return res;
    }

    private AABB getRenderBounds(IFluidTank tank, AABB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.f_82292_ - tankBounds.f_82289_;
        double y1 = tankBounds.f_82289_;
        double y2 = tankBounds.f_82289_ + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getAttributes().getDensity() < 0) {
            double yOff = tankBounds.f_82292_ - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AABB(tankBounds.f_82288_, y1, tankBounds.f_82290_, tankBounds.f_82291_, y2, tankBounds.f_82293_);
    }

    private BakedQuad createQuad(List<Vec3> vecs, float[] cols, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        Vec3 normal = Vec3.m_82528_((Vec3i)face.m_122436_());
        this.putVertex(builder, normal, vecs.get((int)0).f_82479_, vecs.get((int)0).f_82480_, vecs.get((int)0).f_82481_, u1, v1, sprite, cols);
        this.putVertex(builder, normal, vecs.get((int)1).f_82479_, vecs.get((int)1).f_82480_, vecs.get((int)1).f_82481_, u1, v2, sprite, cols);
        this.putVertex(builder, normal, vecs.get((int)2).f_82479_, vecs.get((int)2).f_82480_, vecs.get((int)2).f_82481_, u2, v2, sprite, cols);
        this.putVertex(builder, normal, vecs.get((int)3).f_82479_, vecs.get((int)3).f_82480_, vecs.get((int)3).f_82481_, u2, v1, sprite, cols);
        builder.setQuadOrientation(face);
        return builder.build();
    }

    private void putVertex(BakedQuadBuilder builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float[] col) {
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block6: for (int e = 0; e < elements.size(); ++e) {
            switch (((VertexFormatElement)elements.get(e)).m_86048_()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{col[1], col[2], col[3], col[0]});
                    continue block6;
                }
                case UV: {
                    if (((VertexFormatElement)elements.get(e)).m_86049_() == 0) {
                        float iu = sprite.m_118367_((double)u);
                        float iv = sprite.m_118393_((double)v);
                        builder.put(e, new float[]{iu, iv});
                        continue block6;
                    }
                    builder.put(e, new float[0]);
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public boolean m_7541_() {
        return this.bakedBaseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.bakedBaseModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.bakedBaseModel.m_7521_();
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.bakedBaseModel.getParticleIcon(data);
    }

    public TextureAtlasSprite m_6160_() {
        return this.bakedBaseModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.transformMap, (ItemTransforms.TransformType)cameraTransformType, (PoseStack)mat);
    }

    private static class FluidOverridesList
    extends ItemOverrides {
        private final FluidItemModel modelIn;

        FluidOverridesList(FluidItemModel modelIn) {
            this.modelIn = modelIn;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel original, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            Item item = stack.m_41720_();
            if (item instanceof IFluidRendered) {
                IFluidRendered r = (IFluidRendered)item;
                this.modelIn.tanksToRender = r.getFluidItemRenderer().getTanksToRender(stack);
            }
            return this.modelIn;
        }
    }

    public static enum Loader implements IModelLoader<Geometry>
    {
        INSTANCE;


        public void m_6213_(ResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"base_model"), BlockModel.class);
            return new Geometry(baseModel);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        private final BlockModel baseModel;

        Geometry(BlockModel baseModel) {
            this.baseModel = baseModel;
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new FluidItemModel(this.baseModel.m_111449_(bakery, this.baseModel.f_111418_, spriteGetter, modelTransform, modelLocation, true), (ImmutableMap<ItemTransforms.TransformType, Transformation>)PerspectiveMapWrapper.getTransforms((ItemTransforms)this.baseModel.m_111491_()));
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.baseModel.m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

