/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.DyeColor;

public class WidgetColorSelector
extends WidgetButtonExtended
implements IDrawAfterRender {
    private boolean expanded = false;
    private DyeColor color = DyeColor.WHITE;
    private final Rect2i mainArea;
    private final Rect2i expandedArea;
    private final Consumer<WidgetColorSelector> callback;

    public WidgetColorSelector(int xIn, int yIn) {
        this(xIn, yIn, null);
    }

    public WidgetColorSelector(int xIn, int yIn, Consumer<WidgetColorSelector> callback) {
        super(xIn, yIn, 16, 16, TextComponent.f_131282_);
        this.mainArea = new Rect2i(xIn, yIn, this.f_93618_, this.f_93619_);
        this.expandedArea = new Rect2i(xIn, yIn + this.f_93619_, this.f_93618_ * 4, this.f_93619_ * 4);
        this.callback = callback;
    }

    public WidgetColorSelector withInitialColor(DyeColor color) {
        this.color = color;
        return this;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        super.m_6303_(matrixStack, mouseX, mouseY, partialTick);
        WidgetColorSelector.m_93172_((PoseStack)matrixStack, (int)(this.f_93620_ + 3), (int)(this.f_93621_ + 3), (int)(this.f_93620_ + this.f_93618_ - 4), (int)(this.f_93621_ + this.f_93619_ - 4), (int)(0xFF000000 | PneumaticCraftUtils.getDyeColorAsRGB(this.color)));
        this.m_93154_(matrixStack, this.f_93620_ + 3, this.f_93620_ + this.f_93618_ - 3, this.f_93621_ + this.f_93619_ - 4, -10461088);
        this.m_93222_(matrixStack, this.f_93620_ + this.f_93618_ - 4, this.f_93621_ + 3, this.f_93621_ + this.f_93619_ - 3, -10461088);
    }

    @Override
    public void renderAfterEverythingElse(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.expanded) {
            WidgetColorSelector.m_93172_((PoseStack)matrixStack, (int)this.f_93620_, (int)(this.f_93621_ - 1 + this.f_93619_), (int)(this.f_93620_ + this.f_93618_ * 4), (int)(this.f_93621_ - 1 + this.f_93619_ * 5), (int)-16777216);
            WidgetColorSelector.m_93172_((PoseStack)matrixStack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + this.f_93619_), (int)(this.f_93620_ + this.f_93618_ * 4 - 1), (int)(this.f_93621_ - 2 + this.f_93619_ * 5), (int)-8355712);
            for (DyeColor color : DyeColor.values()) {
                int dx = this.f_93620_ + color.m_41060_() % 4 * 16;
                int dy = this.f_93621_ - 1 + this.f_93619_ + color.m_41060_() / 4 * 16;
                WidgetColorSelector.m_93172_((PoseStack)matrixStack, (int)(dx + 3), (int)(dy + 3), (int)(dx + 13), (int)(dy + 13), (int)(0xFF000000 | PneumaticCraftUtils.getDyeColorAsRGB(color)));
                this.m_93154_(matrixStack, dx + 3, dx + 13, dy + 13, -10461088);
                this.m_93222_(matrixStack, dx + 13, dy + 3, dy + 13, -10461088);
            }
        }
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return super.m_93680_(mouseX, mouseY) || this.expanded && this.expandedArea.m_110087_((int)mouseX, (int)mouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.mainArea.m_110087_((int)mouseX, (int)mouseY)) {
            this.expanded = !this.expanded;
        } else if (this.expandedArea.m_110087_((int)mouseX, (int)mouseY)) {
            int dx = (int)mouseX - this.expandedArea.m_110085_();
            int dy = (int)mouseY - this.expandedArea.m_110086_();
            int id = dx / 16 + dy / 16 * 4;
            this.color = DyeColor.m_41053_((int)id);
            boolean bl = this.expanded = !this.expanded;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }
}

