/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.VacuumPumpBlockEntity;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.VacuumPumpMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class VacuumPumpScreen
extends AbstractPneumaticCraftContainerScreen<VacuumPumpMenu, VacuumPumpBlockEntity> {
    public VacuumPumpScreen(VacuumPumpMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_VACUUM_PUMP;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        super.m_7027_(matrixStack, x, y);
        this.f_96547_.m_92883_(matrixStack, "+", 32.0f, 47.0f, -16733696);
        this.f_96547_.m_92883_(matrixStack, "-", 138.0f, 47.0f, -65536);
        float pressure = ((IAirHandlerMachine)((VacuumPumpBlockEntity)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((VacuumPumpBlockEntity)this.te).getInputSide()).orElseThrow(RuntimeException::new)).getPressure();
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.f_96547_, -1.0f, 7.0f, 5.0f, 2.0f, pressure, this.f_97726_ / 5, this.f_97727_ / 5 + 4);
        float vacPressure = ((IAirHandlerMachine)((VacuumPumpBlockEntity)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((VacuumPumpBlockEntity)this.te).getVacuumSide()).orElseThrow(RuntimeException::new)).getPressure();
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.f_96547_, -1.0f, 7.0f, 5.0f, -1.0f, vacPressure, this.f_97726_ * 4 / 5, this.f_97727_ / 5 + 4);
    }

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        IAirHandlerMachine inputAirHandler = (IAirHandlerMachine)((VacuumPumpBlockEntity)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((VacuumPumpBlockEntity)this.te).getInputSide()).orElseThrow(RuntimeException::new);
        IAirHandlerMachine vacuumHandler = (IAirHandlerMachine)((VacuumPumpBlockEntity)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((VacuumPumpBlockEntity)this.te).getVacuumSide()).orElseThrow(RuntimeException::new);
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.inputPressure", PneumaticCraftUtils.roundNumberTo(inputAirHandler.getPressure(), 2)));
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.vacuumPressure", PneumaticCraftUtils.roundNumberTo(vacuumHandler.getPressure(), 2)));
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.inputAir", String.format("%,d", inputAirHandler.getAir())));
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.vacuumAir", String.format("%,d", vacuumHandler.getAir())));
        int volume = inputAirHandler.getVolume();
        int upgrades = ((VacuumPumpBlockEntity)this.te).getUpgrades((PNCUpgrade)((Object)ModUpgrades.VOLUME.get()));
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.baseVolume", String.format("%,d", 2000)));
        if (volume > inputAirHandler.getBaseVolume()) {
            pressureStatText.add((Component)new TextComponent("\u25b6 " + upgrades + " x ").m_7220_(((PNCUpgrade)((Object)ModUpgrades.VOLUME.get())).getItemStack().m_41786_()));
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.effectiveVolume", String.format("%,d", volume)));
        }
        if (((VacuumPumpBlockEntity)this.te).turning) {
            int suction = Math.round(4.0f * ((VacuumPumpBlockEntity)this.te).getSpeedMultiplierFromUpgrades());
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.suction", String.format("%,d", suction)));
        }
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        float pressure = ((Float)((VacuumPumpBlockEntity)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((VacuumPumpBlockEntity)this.te).getInputSide()).map(IAirHandler::getPressure).orElseThrow(RuntimeException::new)).floatValue();
        if (pressure < 2.0f) {
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.notEnoughPressure", new Object[0]));
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.applyPressure", Float.valueOf(2.0f)).m_130940_(ChatFormatting.BLACK));
        }
    }
}

