/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.FluxCompressorBlockEntity;
import me.desht.pneumaticcraft.common.inventory.FluxCompressorMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class FluxCompressorScreen
extends AbstractPneumaticCraftContainerScreen<FluxCompressorMenu, FluxCompressorBlockEntity> {
    private WidgetAnimatedStat inputStat;
    private WidgetTemperature tempWidget;

    public FluxCompressorScreen(FluxCompressorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.inputStat = this.addAnimatedStat((Component)new TextComponent("Input"), Textures.GUI_BUILDCRAFT_ENERGY, -11184811, false);
        ((FluxCompressorBlockEntity)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> this.m_142416_((GuiEventListener)new WidgetEnergy(this.f_97735_ + 20, this.f_97736_ + 20, (IEnergyStorage)storage)));
        this.tempWidget = new WidgetTemperature(this.f_97735_ + 97, this.f_97736_ + 20, TemperatureRange.of(223, 673), 273, 50).setOperatingRange(TemperatureRange.of(323, 625)).setShowOperatingRange(false);
        this.m_142416_((GuiEventListener)this.tempWidget);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected PointXY getGaugeLocation() {
        return super.getGaugeLocation().add(10, 0);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.inputStat.setText(this.getOutputStat());
        this.tempWidget.setTemperature(((FluxCompressorBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt());
        this.tempWidget.autoScaleForTemperature();
    }

    private List<Component> getOutputStat() {
        ArrayList<Component> textList = new ArrayList<Component>();
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.fluxCompressor.maxEnergyUsage", new Object[0]).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)new TextComponent(((FluxCompressorBlockEntity)this.te).getInfoEnergyPerTick() + " FE/t").m_130940_(ChatFormatting.BLACK));
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.fluxCompressor.maxInputRate", new Object[0]).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)new TextComponent(((FluxCompressorBlockEntity)this.te).getInfoEnergyPerTick() * 2 + " FE/t").m_130940_(ChatFormatting.BLACK));
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.fluxCompressor.storedEnergy", new Object[0]).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)new TextComponent(((FluxCompressorBlockEntity)this.te).getInfoEnergyStored() + " FE").m_130940_(ChatFormatting.BLACK));
        return textList;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((FluxCompressorBlockEntity)this.te).getAirRate(), 2)));
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        if (((FluxCompressorBlockEntity)this.te).getInfoEnergyPerTick() > ((FluxCompressorBlockEntity)this.te).getInfoEnergyStored()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.fluxCompressor.noRF", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (((FluxCompressorBlockEntity)this.te).getHeatEfficiency() < 100) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.advancedAirCompressor.efficiency", ((FluxCompressorBlockEntity)this.te).getHeatEfficiency() + "%"));
        }
    }
}

