/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.item;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public interface IUpgradeRegistry {
    public void addApplicableUpgrades(BlockEntityType<?> var1, Builder var2);

    public void addApplicableUpgrades(EntityType<?> var1, Builder var2);

    public void addApplicableUpgrades(Item var1, Builder var2);

    public int getMaxUpgrades(BlockEntity var1, PNCUpgrade var2);

    public int getMaxUpgrades(Entity var1, PNCUpgrade var2);

    public int getMaxUpgrades(Item var1, PNCUpgrade var2);

    public void addUpgradeTooltip(PNCUpgrade var1, List<Component> var2);

    public Item makeUpgradeItem(Supplier<PNCUpgrade> var1, int var2);

    public Item makeUpgradeItem(Supplier<PNCUpgrade> var1, int var2, Item.Properties var3);

    public int getUpgradeCount(ItemStack var1, PNCUpgrade var2);

    public Map<PNCUpgrade, Integer> getAllUpgrades(ItemStack var1);

    public static class Builder {
        private final Map<PNCUpgrade, Integer> upgrades = new HashMap<PNCUpgrade, Integer>();

        public Builder() {
        }

        private Builder(Builder copy) {
            this.upgrades.putAll(copy.upgrades);
        }

        public static Builder copyOf(Builder builder) {
            return new Builder(builder);
        }

        public static Builder of(PNCUpgrade upgrade, int amount) {
            return new Builder().with(upgrade, amount);
        }

        public Builder with(PNCUpgrade upgrade, int amount) {
            this.upgrades.put(upgrade, amount);
            return this;
        }

        public Map<PNCUpgrade, Integer> getUpgrades() {
            return ImmutableMap.copyOf(this.upgrades);
        }
    }
}

