/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.TransferRecipeMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;

public abstract class CraftingContainerRecipeTransferHandlerBase<C extends StorageContainerMenuBase<?>>
implements IRecipeTransferHandler<C, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IStackHelper stackHelper;

    protected CraftingContainerRecipeTransferHandlerBase(IRecipeTransferHandlerHelper handlerHelper, IStackHelper stackHelper) {
        this.handlerHelper = handlerHelper;
        this.stackHelper = stackHelper;
    }

    public Class<CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    public IRecipeTransferError transferRecipe(C container, CraftingRecipe recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        Optional potentialCraftingContainer = ((StorageContainerMenuBase)container).getOpenOrFirstCraftingContainer();
        if (potentialCraftingContainer.isEmpty()) {
            return this.handlerHelper.createInternalError();
        }
        Map<Integer, Slot> inventorySlots = this.getInventorySlots((StorageContainerMenuBase<?>)container);
        UpgradeContainerBase openOrFirstCraftingContainer = (UpgradeContainerBase)potentialCraftingContainer.get();
        Map<Integer, Slot> craftingSlots = this.getCraftingSlots((ICraftingContainer)((Object)openOrFirstCraftingContainer));
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        int inputCount = this.getInputCount(itemStackGroup);
        if (inputCount > craftingSlots.size()) {
            SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}", CraftingContainerRecipeTransferHandlerBase.class, container.getClass());
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            ItemStack stack = slot.m_7993_();
            if (stack.m_41619_()) continue;
            if (!slot.m_8010_(player)) {
                SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", CraftingContainerRecipeTransferHandlerBase.class, container.getClass(), (Object)slot.f_40219_);
                return this.handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.f_40219_, stack.m_41777_());
        }
        int emptySlotCount = this.getEmptySlotCount(inventorySlots, availableItemStacks);
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)new TranslatableComponent("jei.tooltip.error.recipe.transfer.inventory.full"));
        }
        MatchingItemsResult matchingItemsResult = this.getMatchingItems(this.stackHelper, availableItemStacks, itemStackGroup.getGuiIngredients());
        if (!matchingItemsResult.missingItems.isEmpty()) {
            return this.handlerHelper.createUserErrorForSlots((Component)new TranslatableComponent("jei.tooltip.error.recipe.transfer.missing"), matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        if (doTransfer) {
            if (!openOrFirstCraftingContainer.isOpen()) {
                ((StorageContainerMenuBase)container).getOpenContainer().ifPresent(c -> {
                    c.setIsOpen(false);
                    container.setOpenTabId(-1);
                });
                openOrFirstCraftingContainer.setIsOpen(true);
                ((StorageContainerMenuBase)container).setOpenTabId(openOrFirstCraftingContainer.getUpgradeContainerId());
            }
            TransferRecipeMessage message = new TransferRecipeMessage(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer);
            PacketHandler.INSTANCE.sendToServer(message);
        }
        return null;
    }

    private int getEmptySlotCount(Map<Integer, Slot> inventorySlots, Map<Integer, ItemStack> availableItemStacks) {
        int emptySlotCount = 0;
        for (Slot slot : inventorySlots.values()) {
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                availableItemStacks.put(slot.f_40219_, stack.m_41777_());
                continue;
            }
            ++emptySlotCount;
        }
        return emptySlotCount;
    }

    private int getInputCount(IGuiItemStackGroup itemStackGroup) {
        int inputCount = 0;
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++inputCount;
        }
        return inputCount;
    }

    private Map<Integer, Slot> getCraftingSlots(ICraftingContainer openOrFirstCraftingContainer) {
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        List<Slot> recipeSlots = openOrFirstCraftingContainer.getRecipeSlots();
        for (Slot slot : recipeSlots) {
            craftingSlots.put(slot.f_40219_, slot);
        }
        return craftingSlots;
    }

    private Map<Integer, Slot> getInventorySlots(StorageContainerMenuBase<?> container) {
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : container.realInventorySlots) {
            inventorySlots.put(slot.f_40219_, slot);
        }
        return inventorySlots;
    }

    private MatchingItemsResult getMatchingItems(IStackHelper stackhelper, Map<Integer, ItemStack> availableItemStacks, Map<Integer, ? extends IGuiIngredient<ItemStack>> ingredientsMap) {
        MatchingItemsResult matchingItemResult = new MatchingItemsResult();
        int recipeSlotNumber = -1;
        TreeSet<Integer> ingredientSlots = new TreeSet<Integer>(ingredientsMap.keySet());
        Iterator iterator = ingredientSlots.iterator();
        while (iterator.hasNext()) {
            int ingredientSlot = (Integer)iterator.next();
            IGuiIngredient<ItemStack> ingredient = ingredientsMap.get(ingredientSlot);
            if (!ingredient.isInput()) continue;
            ++recipeSlotNumber;
            List requiredStacks = ingredient.getAllIngredients();
            if (requiredStacks.isEmpty()) continue;
            this.tryToMatchStacks(stackhelper, availableItemStacks, matchingItemResult, recipeSlotNumber, ingredientSlot, requiredStacks);
        }
        return matchingItemResult;
    }

    private void tryToMatchStacks(IStackHelper stackhelper, Map<Integer, ItemStack> availableItemStacks, MatchingItemsResult matchingItemResult, int recipeSlotNumber, int ingredientSlot, List<ItemStack> requiredStacks) {
        Integer matching = CraftingContainerRecipeTransferHandlerBase.containsAnyStackIndexed(stackhelper, availableItemStacks, requiredStacks);
        if (matching == null) {
            matchingItemResult.missingItems.add(ingredientSlot);
        } else {
            ItemStack matchingStack = availableItemStacks.get(matching);
            matchingStack.m_41774_(1);
            if (matchingStack.m_41613_() == 0) {
                availableItemStacks.remove(matching);
            }
            matchingItemResult.matchingItems.put(recipeSlotNumber, matching);
        }
    }

    @Nullable
    public static Integer containsAnyStackIndexed(IStackHelper stackhelper, Map<Integer, ItemStack> stacks, Iterable<ItemStack> contains) {
        MatchingIndexed matchingStacks = new MatchingIndexed(stacks);
        MatchingIterable matchingContains = new MatchingIterable(contains);
        return CraftingContainerRecipeTransferHandlerBase.containsStackMatchable(stackhelper, matchingStacks, matchingContains);
    }

    @Nullable
    public static <R, T> R containsStackMatchable(IStackHelper stackhelper, Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        ItemStackMatchable<T> containStack;
        R matchingStack;
        Iterator<ItemStackMatchable<T>> var3 = contains.iterator();
        do {
            if (var3.hasNext()) continue;
            return null;
        } while ((matchingStack = CraftingContainerRecipeTransferHandlerBase.containsStack(stackhelper, stacks, containStack = var3.next())) == null);
        return matchingStack;
    }

    @Nullable
    public static <R> R containsStack(IStackHelper stackHelper, Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        ItemStackMatchable<R> stack;
        Iterator<ItemStackMatchable<R>> var3 = stacks.iterator();
        do {
            if (!var3.hasNext()) {
                return null;
            }
            stack = var3.next();
        } while (!stackHelper.isEquivalent(contains.getStack(), stack.getStack(), UidContext.Recipe));
        return stack.getResult();
    }

    public static class MatchingItemsResult {
        public final Map<Integer, Integer> matchingItems = new HashMap<Integer, Integer>();
        public final List<Integer> missingItems = new ArrayList<Integer>();
    }

    private static class MatchingIndexed
    implements Iterable<ItemStackMatchable<Integer>> {
        private final Map<Integer, ItemStack> map;

        public MatchingIndexed(Map<Integer, ItemStack> map) {
            this.map = map;
        }

        @Override
        public Iterator<ItemStackMatchable<Integer>> iterator() {
            return new MatchingIterable.DelegateIterator<Map.Entry<Integer, ItemStack>, ItemStackMatchable<Integer>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Integer> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Integer>(){

                        @Override
                        public ItemStack getStack() {
                            return (ItemStack)entry.getValue();
                        }

                        @Override
                        public Integer getResult() {
                            return (Integer)entry.getKey();
                        }
                    };
                }
            };
        }
    }

    public static class MatchingIterable
    implements Iterable<ItemStackMatchable<ItemStack>> {
        private final Iterable<ItemStack> list;

        public MatchingIterable(Iterable<ItemStack> list) {
            this.list = list;
        }

        @Override
        public Iterator<ItemStackMatchable<ItemStack>> iterator() {
            Iterator<ItemStack> stacks = this.list.iterator();
            return new DelegateIterator<ItemStack, ItemStackMatchable<ItemStack>>(stacks){

                @Override
                public ItemStackMatchable<ItemStack> next() {
                    final ItemStack stack = (ItemStack)this.delegate.next();
                    return new ItemStackMatchable<ItemStack>(){

                        @Override
                        @Nullable
                        public ItemStack getStack() {
                            return stack;
                        }

                        @Override
                        @Nullable
                        public ItemStack getResult() {
                            return stack;
                        }
                    };
                }
            };
        }

        public static abstract class DelegateIterator<T, R>
        implements Iterator<R> {
            protected final Iterator<T> delegate;

            protected DelegateIterator(Iterator<T> delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        }
    }

    public static interface ItemStackMatchable<R> {
        @Nullable
        public ItemStack getStack();

        @Nullable
        public R getResult();
    }
}

