/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.gui.ScrollPanel;

public class InventoryScrollPanel
extends ScrollPanel {
    private static final int TOP_Y_OFFSET = 1;
    private final IInventoryScreen screen;
    private final int firstSlotIndex;
    private final int numberOfSlots;
    private final int slotsInARow;

    public InventoryScrollPanel(Minecraft client, IInventoryScreen screen, int firstSlotIndex, int numberOfSlots, int slotsInARow, int height, int top, int left) {
        super(client, slotsInARow * 18 + 6, height, top, left, 0);
        this.screen = screen;
        this.firstSlotIndex = firstSlotIndex;
        this.numberOfSlots = numberOfSlots;
        this.slotsInARow = slotsInARow;
    }

    protected int getScrollAmount() {
        return 18;
    }

    protected int getContentHeight() {
        int rows = this.numberOfSlots / this.slotsInARow + (this.numberOfSlots % this.slotsInARow > 0 ? 1 : 0);
        return rows * 18;
    }

    protected void drawBackground(PoseStack poseStack, Tesselator tess, float partialTick) {
        this.screen.drawSlotBg(poseStack);
    }

    protected void drawPanel(PoseStack poseStack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)this.screen.getLeftX(), (double)this.screen.getTopY(), 0.0);
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.screen.renderInventorySlots(poseStack, mouseX, mouseY, this.m_5953_(mouseX, mouseY));
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
    }

    public Optional<Slot> findSlot(double mouseX, double mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return Optional.empty();
        }
        for (int slotIndex = this.firstSlotIndex; slotIndex < this.firstSlotIndex + this.numberOfSlots; ++slotIndex) {
            Slot slot = this.screen.getSlot(slotIndex);
            if (!this.screen.isMouseOverSlot(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        boolean ret = super.m_6050_(mouseX, mouseY, scroll);
        this.updateSlotsYPosition();
        return ret;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean ret = super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        this.updateSlotsYPosition();
        return ret;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    public void updateSlotsYPosition() {
        int i = this.firstSlotIndex;
        int row = 0;
        while (i < this.firstSlotIndex + this.numberOfSlots) {
            int newY = this.top - this.screen.getTopY() - (int)this.scrollDistance / 18 * 18 + row * 18 + 1;
            if (newY < -17 || newY > this.height) {
                newY = -100;
            }
            this.screen.getSlot((int)i).f_40221_ = newY;
            row = ++i / this.slotsInARow;
        }
    }

    public static interface IInventoryScreen {
        public void renderInventorySlots(PoseStack var1, int var2, int var3, boolean var4);

        public boolean isMouseOverSlot(Slot var1, double var2, double var4);

        public void drawSlotBg(PoseStack var1);

        public int getTopY();

        public int getLeftX();

        public Slot getSlot(int var1);
    }
}

