/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MultiPartBakedModel.class})
public class MixinMultipartBakedModel {
    private final Map<BlockState, BakedModel[]> stateCacheFast = new Reference2ReferenceOpenHashMap();
    private final StampedLock lock = new StampedLock();
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, BakedModel>> f_119459_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public List<BakedQuad> getQuads(BlockState state, Direction face, Random random, IModelData modelData) {
        BakedModel[] models;
        if (state == null) {
            return Collections.emptyList();
        }
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<BakedModel> modelList = new ArrayList<BakedModel>(this.f_119459_.size());
                for (Pair pair : this.f_119459_) {
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    modelList.add((BakedModel)pair.getRight());
                }
                models = (BakedModel[])modelList.toArray(BakedModel[]::new);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        long seed = random.nextLong();
        for (BakedModel model : models) {
            random.setSeed(seed);
            quads.addAll(model.getQuads(state, face, random, MultipartModelData.resolve((BakedModel)model, (IModelData)modelData)));
        }
        return quads;
    }
}

