/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;

public abstract class PanelScrolledText
extends PanelBase {
    protected List<FormattedCharSequence> myText;
    protected int firstLine = 0;
    protected int maxFirstLine;
    protected int numLines;
    protected boolean scrollable;

    public PanelScrolledText(IGuiAccess gui, int sideIn, String info) {
        super(gui, sideIn);
        this.maxHeight = 92;
        this.myText = this.getFontRenderer().m_92923_((FormattedText)new TextComponent(info), this.maxWidth - 16);
        int n = this.myText.size();
        Objects.requireNonNull(this.getFontRenderer());
        this.numLines = Math.min(n, (this.maxHeight - 24) / 9);
        this.maxFirstLine = this.myText.size() - this.numLines;
        this.scrollable = this.maxFirstLine > 0;
    }

    public abstract TextureAtlasSprite getIcon();

    public abstract Component getTitle();

    @Override
    public void drawForeground(PoseStack matrixStack) {
        this.drawPanelIcon(matrixStack, this.getIcon());
        if (!this.fullyOpen) {
            return;
        }
        if (this.scrollable) {
            if (this.firstLine > 0) {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_ARROW_UP, this.sideOffset() + this.maxWidth - 20, 16);
            } else {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_ARROW_UP_INACTIVE, this.sideOffset() + this.maxWidth - 20, 16);
            }
            if (this.firstLine < this.maxFirstLine) {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_ARROW_DOWN, this.sideOffset() + this.maxWidth - 20, 76);
            } else {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_ARROW_DOWN_INACTIVE, this.sideOffset() + this.maxWidth - 20, 76);
            }
        }
        this.getFontRenderer().m_92750_(matrixStack, this.getTitle().getString(), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        for (int i = this.firstLine; i < this.firstLine + this.numLines; ++i) {
            Font font = this.getFontRenderer();
            float f = this.sideOffset() + 2;
            Objects.requireNonNull(this.getFontRenderer());
            font.m_92877_(matrixStack, this.myText.get(i), f, (float)(20 + (i - this.firstLine) * 9), this.textColor);
        }
        RenderHelper.resetShaderColor();
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        if (!this.fullyOpen) {
            tooltipList.add(this.getTitle());
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        double shiftedMouseX = mouseX - (double)this.posX();
        double shiftedMouseY = mouseY - (double)this.posY();
        if (!this.fullyOpen) {
            return false;
        }
        if (!this.scrollable || shiftedMouseY < 16.0 || shiftedMouseX < (double)(this.maxWidth - 16)) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (shiftedMouseY < 32.0) {
            this.firstLine = MathHelper.clamp(this.firstLine - 1, 0, this.maxFirstLine);
        } else if (shiftedMouseY > (double)(this.maxHeight - 16)) {
            this.firstLine = MathHelper.clamp(this.firstLine + 1, 0, this.maxFirstLine);
        }
        return true;
    }

    @Override
    public boolean mouseWheel(double mouseX, double mouseY, double movement) {
        if (!this.fullyOpen) {
            return false;
        }
        if (movement > 0.0) {
            this.firstLine = MathHelper.clamp(this.firstLine - 1, 0, this.maxFirstLine);
            return true;
        }
        if (movement < 0.0) {
            this.firstLine = MathHelper.clamp(this.firstLine + 1, 0, this.maxFirstLine);
            return true;
        }
        return false;
    }
}

