/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compactmachines")
public class RoomEventHandler {
    @SubscribeEvent
    public static void entityJoined(EntityJoinWorldEvent evt) {
        Entity ent = evt.getEntity();
        if (ent instanceof Player || !ent.f_19853_.m_46472_().equals(Registration.COMPACT_DIMENSION)) {
            return;
        }
        if (ent.f_19853_.f_46443_) {
            return;
        }
        if (!RoomEventHandler.positionInsideRoom(ent, ent.m_20182_())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn evt) {
        Vec3 target = new Vec3(evt.getX(), evt.getY(), evt.getZ());
        Entity ent = evt.getEntity();
        if (!ent.f_19853_.m_46472_().equals(Registration.COMPACT_DIMENSION)) {
            return;
        }
        if (!RoomEventHandler.positionInsideRoom(ent, target)) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent evt) {
        if (evt instanceof EntityTeleportEvent.TeleportCommand) {
            return;
        }
        if (!evt.getEntity().f_19853_.m_46472_().equals(Registration.COMPACT_DIMENSION)) {
            return;
        }
        Entity ent = evt.getEntity();
        RoomEventHandler.doEntityTeleportHandle((EntityEvent)evt, evt.getTarget(), ent);
    }

    private static boolean positionInsideRoom(Entity entity, Vec3 target) {
        Level level = entity.f_19853_;
        if (!level.m_46472_().equals(Registration.COMPACT_DIMENSION)) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel compactDim = (ServerLevel)level;
            ChunkPos machineChunk = new ChunkPos(entity.m_146902_().f_45578_, entity.m_146902_().f_45579_);
            try {
                CompactRoomData intern = CompactRoomData.get(compactDim);
                return intern.getBounds(machineChunk).m_82390_(target);
            }
            catch (NonexistentRoomException e) {
                return false;
            }
        }
        return false;
    }

    private static void doEntityTeleportHandle(EntityEvent evt, Vec3 target, Entity ent) {
        if (!RoomEventHandler.positionInsideRoom(ent, target) && evt.isCancelable()) {
            if (ent instanceof ServerPlayer) {
                ((ServerPlayer)ent).m_5661_((Component)TranslationUtil.message(Messages.TELEPORT_OUT_OF_BOUNDS, ent.m_7755_()).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC), true);
            }
            evt.setCanceled(true);
        }
    }
}

