/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.theoneprobe.providers;

import dev.compactmods.machines.api.location.IDimensionalBlockPosition;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TunnelProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return new ResourceLocation("compactmachines", "tunnel");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo info, Player playerEntity, Level level, BlockState queryState, IProbeHitData hitData) {
        Block block = queryState.m_60734_();
        if (!(block instanceof TunnelWallBlock)) {
            return;
        }
        TunnelWallBlock tb = (TunnelWallBlock)block;
        Direction side = (Direction)queryState.m_61143_((Property)TunnelWallBlock.CONNECTED_SIDE);
        ILayoutStyle center = info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IProbeInfo v = info.vertical(info.defaultLayoutStyle().spacing(-1));
        BlockEntity blockEntity = level.m_7702_(hitData.getPos());
        if (blockEntity instanceof TunnelWallEntity) {
            TunnelWallEntity tile = (TunnelWallEntity)blockEntity;
            if (probeMode == ProbeMode.EXTENDED) {
                TunnelDefinition definition = tile.getTunnelType();
                MutableComponent tunType = new TextComponent(definition.getRegistryName().toString()).m_130940_(ChatFormatting.GRAY);
                CompoundText type = CompoundText.create().name((Component)tunType);
                v.horizontal(center).item(new ItemStack((ItemLike)Tunnels.ITEM_TUNNEL.get())).text(type);
            }
            String sideTranslated = "{*".concat("compactmachines.direction.").concat(side.m_122433_()).concat("*}");
            v.horizontal(center).item(new ItemStack((ItemLike)Items.f_42522_)).text((Component)new TranslatableComponent(sideTranslated));
            IDimensionalBlockPosition connectedTo = tile.getConnectedPosition();
            if (connectedTo != null) {
                ServerLevel connectedWorld = (ServerLevel)level;
                BlockPos outPosBlock = connectedTo.getBlockPosition();
                try {
                    BlockState state = connectedTo.state(level.m_142572_());
                    if (!state.m_60795_()) {
                        String blockName = "{*" + state.m_60734_().m_7705_() + "*}";
                        BlockHitResult trace = new BlockHitResult(hitData.getHitVec(), hitData.getSideHit(), outPosBlock, false);
                        ItemStack pick = state.m_60734_().getCloneItemStack(state, (HitResult)trace, (BlockGetter)connectedWorld, outPosBlock, playerEntity);
                        v.horizontal(center).item(pick).text((Component)new TranslatableComponent("compactmachines".concat(".connected_block"), new Object[]{blockName}));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

